% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-electrode-abstract.R
\name{RAVEAbstarctElectrode}
\alias{RAVEAbstarctElectrode}
\title{Abstract definition of electrode class in RAVE}
\description{
This class is not intended for direct use. Please
create new child classes and implement some key methods.
}
\examples{
\dontrun{

# To run this example, please download demo subject (~700 MB) from
# https://github.com/beauchamplab/rave/releases/tag/v0.1.9-beta

generator <- RAVEAbstarctElectrode

# load demo subject electrode 14
e <- generator$new("demo/DemoSubject", number = 14)

# set epoch
e$subject$epoch_names
e$set_epoch("auditory_onset")
head(e$epoch$table)

# set epoch range (-1 to 2 seconds relative to onset)
e$trial_intervals <- c(-1,2)
# or to set multiple ranges
e$trial_intervals <- list(c(-2,-1), c(0, 2))

# set reference
e$subject$reference_names
reference_table <- e$subject$meta_data(
  meta_type = "reference",
  meta_name = "default")
ref_name <- subset(reference_table, Electrode == 14)[["Reference"]]

# the reference is CAR type, mean of electrode 13-16,24
ref_name

# load & set reference
ref <- generator$new(e$subject, ref_name, is_reference = TRUE)
e$.set_reference(ref, e$type)

}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{type}}{type of electrode}

\item{\code{subject}}{subject instance (\code{\link{RAVESubject}})}

\item{\code{number}}{integer stands for electrode number or reference ID}

\item{\code{reference}}{reference electrode, either \code{NULL} for no reference
or an electrode instance inherits \code{RAVEAbstarctElectrode}}

\item{\code{epoch}}{a \code{\link{RAVEEpoch}} instance}

\item{\code{is_reference}}{whether this instance is a reference electrode}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{exists}}{whether electrode exists in subject}

\item{\code{preprocess_file}}{path to preprocess 'HDF5' file}

\item{\code{power_file}}{path to power 'HDF5' file}

\item{\code{phase_file}}{path to phase 'HDF5' file}

\item{\code{voltage_file}}{path to voltage 'HDF5' file}

\item{\code{reference_name}}{reference electrode name}

\item{\code{epoch_name}}{current epoch name}

\item{\code{cache_root}}{run-time cache path; \code{NA} if epoch or trial
intervals are missing}

\item{\code{trial_intervals}}{trial intervals relative to epoch onset}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RAVEAbstarctElectrode$new()}}
\item \href{#method-.set_reference}{\code{RAVEAbstarctElectrode$.set_reference()}}
\item \href{#method-set_epoch}{\code{RAVEAbstarctElectrode$set_epoch()}}
\item \href{#method-clear_cache}{\code{RAVEAbstarctElectrode$clear_cache()}}
\item \href{#method-clear_memory}{\code{RAVEAbstarctElectrode$clear_memory()}}
\item \href{#method-load_data}{\code{RAVEAbstarctElectrode$load_data()}}
\item \href{#method-clone}{\code{RAVEAbstarctElectrode$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$new(subject, number, is_reference = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{character or \code{\link{RAVESubject}} instance}

\item{\code{number}}{current electrode number or reference ID}

\item{\code{is_reference}}{whether instance is a reference}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.set_reference"></a>}}
\if{latex}{\out{\hypertarget{method-.set_reference}{}}}
\subsection{Method \code{.set_reference()}}{
set reference for instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$.set_reference(reference, type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{\code{NULL} or \code{RAVEAbstarctElectrode} instance}

\item{\code{type}}{reference electrode type, default is the same as current
instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_epoch"></a>}}
\if{latex}{\out{\hypertarget{method-set_epoch}{}}}
\subsection{Method \code{set_epoch()}}{
set epoch instance for the electrode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$set_epoch(epoch)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epoch}}{characters or \code{\link{RAVEEpoch}} instance. For
characters, make sure \code{"epoch_<name>.csv"} is in meta folder.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
method to clear cache on hard drive
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$clear_cache(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{implemented by child instances}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_memory"></a>}}
\if{latex}{\out{\hypertarget{method-clear_memory}{}}}
\subsection{Method \code{clear_memory()}}{
method to clear memory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$clear_memory(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{implemented by child instances}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_data"></a>}}
\if{latex}{\out{\hypertarget{method-load_data}{}}}
\subsection{Method \code{load_data()}}{
method to load electrode data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_data(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{data type such as \code{"power"}, \code{"phase"},
\code{"voltage"}, \code{"wavelet-coefficient"}, or others
depending on child class implementations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
