% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambient_shade.R
\name{ambient_shade}
\alias{ambient_shade}
\title{Calculate Ambient Occlusion Map}
\usage{
ambient_shade(
  heightmap,
  anglebreaks = 90 * cospi(seq(5, 85, by = 5)/180),
  sunbreaks = 24,
  maxsearch = 30,
  multicore = FALSE,
  zscale = 1,
  cache_mask = NULL,
  shadow_cache = NULL,
  progbar = interactive(),
  ...
)
}
\arguments{
\item{heightmap}{A two-dimensional matrix, where each entry in the matrix is the elevation at that point. All points are assumed to be evenly spaced.}

\item{anglebreaks}{Default `90*cospi(seq(5, 85,by =5)/180)`. The angle(s), in degrees, as measured from the horizon from which the light originates.}

\item{sunbreaks}{Default `24`. Number of rays to be sent out in a circle, evenly spaced, around the point being tested.}

\item{maxsearch}{Default `30`. The maximum horizontal distance that the system should propogate rays to check for surface intersections.}

\item{multicore}{Default FALSE. If TRUE, multiple cores will be used to compute the shadow matrix. By default, this uses all cores available, unless the user has
set `options("cores")` in which the multicore option will only use that many cores.}

\item{zscale}{Default 1. The ratio between the x and y spacing (which are assumed to be equal) and the z axis.}

\item{cache_mask}{Default `NULL`. A matrix of 1 and 0s, indicating which points on which the raytracer will operate.}

\item{shadow_cache}{Default `NULL`. The shadow matrix to be updated at the points defined by the argument `cache_mask`.}

\item{progbar}{Default `TRUE` if interactive, `FALSE` otherwise. If `FALSE`, turns off progress bar.}

\item{...}{Additional arguments to pass to the `makeCluster` function when `multicore=TRUE`.}
}
\value{
Shaded texture map.
}
\description{
Calculates Ambient Occlusion Shadow Map
}
\examples{
#Here we produce a ambient occlusion map of the `montereybay` elevation map.
\dontrun{
amb = ambient_shade(heightmap = montereybay)
plot_map(amb)
}

#We can increase the distance to look for surface intersections `maxsearch`
#and the density of rays sent out around the point `sunbreaks`.
\dontrun{
amb = ambient_shade(heightmap = montereybay,sunbreaks=24,maxsearch=50)
plot_map(amb)
}
}
