% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shape.R
\name{rotate_mesh}
\alias{rotate_mesh}
\title{Rotate Mesh}
\usage{
rotate_mesh(
  mesh,
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3)
)
}
\arguments{
\item{mesh}{The mesh.}

\item{angle}{Default `c(0,0,0)`. The rotation amount for the x/y/z axes, in degrees.}

\item{pivot_point}{Default `c(0,0,0)`. The pivot point of the rotation.}

\item{order_rotation}{Default `c(1,2,3)`. The order in which to perform the rotations.}
}
\value{
Rotated Mesh
}
\description{
Rotate Mesh
}
\examples{
if(rayvertex:::run_documentation()) {
#Rotate a mesh in the Cornell box
robj = obj_mesh(r_obj(), scale=80,angle=c(0,180,0))

generate_cornell_mesh() |>
add_shape(rotate_mesh(translate_mesh(robj,c(400,0,155)),c(0,30,0), 
                      pivot_point=c(400,0,155))) |>
add_shape(rotate_mesh(translate_mesh(robj,c(555/2,100,555/2)),c(-30,60,30), 
                      pivot_point=c(555/2,100,555/2))) |>
add_shape(rotate_mesh(translate_mesh(robj,c(155,200,400)),c(-30,60,30), 
                      pivot_point=c(155,200,400), order_rotation=c(3,2,1))) |>
rasterize_scene(light_info=directional_light(direction=c(0.1,0.6,-1)))
}
}
