% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{Bacon.hist}
\alias{Bacon.hist}
\title{Calculate age distributions of depths.}
\usage{
Bacon.hist(
  d,
  set = get("info"),
  BCAD = set$BCAD,
  age.lab = c(),
  age.lim = c(),
  hist.lab = "Frequency",
  calc.range = TRUE,
  hist.lim = c(),
  draw = TRUE,
  prob = set$prob,
  hist.col = grey(0.5),
  hist.border = grey(0.2),
  range.col = "blue",
  med.col = "green",
  mean.col = "red",
  verbose = TRUE,
  save.info = set$save.info
)
}
\arguments{
\item{d}{The depth or depths for which a histogram and age ranges should be provided. If multiple depths are given, then just the age ranges, median and means (no graphs) are provided for each depth.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{age.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{age.lim=c()}).}

\item{hist.lab}{The y-axis is labelled \code{ylab="Frequency"} by default.}

\item{calc.range}{Calculate ranges? Takes time so can be left out}

\item{hist.lim}{Limits of the y-axis.}

\item{draw}{Draw a plot or not. Defaults to \code{draw=TRUE}, however no plots are made if more than one depth \code{d} is provided.
If \code{draw=FALSE}, then the age ranges, median and mean are given for each depth (as four columns).}

\item{prob}{Age ranges are given as quantiles, e.g., 2.5\% and 97.5\% for the default of 95\% confidence limits (\code{prob=0.95})).}

\item{hist.col}{Colour of the histogram. Default grey, \code{hist.col=grey(0.5)}.}

\item{hist.border}{Colour of the histogram's outline. Default dark grey, \code{hist.border=grey(0.2)}.}

\item{range.col}{Colour of confidence ranges. Defaults to \code{range.col="blue"}.}

\item{med.col}{Colour of the median. Defaults to \code{med.col="green"}.}

\item{mean.col}{Colour of the mean. Defaults to \code{mn.col="red"}.}

\item{verbose}{Provide feedback on what is happening (default \code{verbose=TRUE}).}

\item{save.info}{A variable called `info' with relevant information about the run (e.g., core name, priors, settings, ages, output) can be saved into the working directory. Note that this will overwrite any existing variable with the same name - as an alternative, one could run, e.g., \code{myvar <- Bacon()}, followed by supplying the variable \code{myvar} in any subsequent commands.}
}
\value{
A local variable called `hists', and a plot with the histogram and the age ranges, median and mean, or just the age ranges, medians and means if more than one depth \code{d} is given.
}
\description{
Calculate the distribution of age estimates of single or multiple depths.
}
\details{
Age estimates of specific depths can also be plotted.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(age.res=50, d.res=50, d.by=10)
  Bacon.hist(20)
  Bacon.hist(20:30)
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
