% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_gettitlemetadata.R
\name{bhl_gettitlemetadata}
\alias{bhl_gettitlemetadata}
\title{Get title metadata}
\usage{
bhl_gettitlemetadata(titleid = NA, items = FALSE, as = "list",
  key = NULL, ...)
}
\arguments{
\item{titleid}{the identifier of an individual title (numeric)}

\item{items}{(logical) TRUE of FALSE (default) to inclue items}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return metadata about a title. You may choose to include a list of
the items (books) associated  with the title.
}
\examples{
\dontrun{
bhl_gettitlemetadata(1726, TRUE)
bhl_gettitlemetadata(1726, as='list')
bhl_gettitlemetadata(1726, as='xml')
}
}

