% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.r
\name{documentation_default}
\alias{documentation_default}
\title{documentation_default}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{mtx}{A matrix-like object.}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{md}{Dataset field(s) to include in the output data frame, or \code{'.all'}
to include all metadata fields. Default: \code{'.all'}}

\item{adiv}{Alpha diversity metric(s) to use. Options are: \code{"OTUs"},
\code{"Shannon"}, \code{"Chao1"}, \code{"Simpson"}, and/or
\code{"InvSimpson"}. Set \code{adiv=".all"} to use all metrics.
Multiple/abbreviated values allowed.
Default: \code{"Shannon"}}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{ord}{Method for reducing dimensionality. Options are:
\describe{
\item{\code{"PCoA"} - }{ Principal coordinate analysis; \code{\link[ape:pcoa]{ape::pcoa()}}. }
\item{\code{"UMAP"} - }{ Uniform manifold approximation and projection; \code{\link[uwot:umap]{uwot::umap()}}. }
\item{\code{"NMDS"} - }{ Nonmetric multidimensional scaling; \code{\link[vegan:metaMDS]{vegan::metaMDS()}}. }
\item{\code{"tSNE"} - }{ t-distributed stochastic neighbor embedding; \code{\link[tsne:tsne]{tsne::tsne()}}. }
}
Multiple/abbreviated values allowed. Default: \code{"PCoA"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{delta}{For numeric metadata, report the absolute difference in values
for the two samples, for instance \code{2} instead of \code{"10 vs 12"}.
Default: \code{TRUE}}

\item{rank}{What rank(s) of taxa to display. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{-1}.}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce
\verb{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}.
Otherwise the taxa name will simply be \code{Coriobacteriales}. You
want to set this to TRUE when \code{unc = "asis"} and you have taxa
names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks. Default: \code{FALSE}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{other}{Sum all non-itemized taxa into an "Other" taxa. When
\code{FALSE}, only returns taxa matched by the \code{taxa}
argument. Specifying \code{TRUE} adds "Other" to the returned set.
A string can also be given to imply \code{TRUE}, but with that
value as the name to use instead of "Other".
Default: \code{FALSE}}

\item{sparse}{If \code{TRUE}, returns a
\code{\link[slam:matrix]{slam::simple_triplet_matrix()}}, otherwise returns a
normal R matrix object. Default: \code{FALSE}}

\item{p.top}{Only display taxa with the most significant differences in
abundance. If \code{p.top} is >= 1, then the \code{p.top} most
significant taxa are displayed. If \code{p.top} is less than one, all
taxa with an adjusted p-value <= \code{p.top} are displayed.
Recommended to be used in combination with the \code{taxa} parameter
to set a lower bound on the mean abundance of considered taxa.
Default: \code{Inf}}

\item{y.transform}{The transformation to apply to the y-axis. Visualizing
differences of both high- and low-abundance taxa is best done with
a non-linear axis. Options are:
\describe{
\item{\code{"sqrt"} - }{ square-root transformation }
\item{\code{"log1p"} - }{ log(y + 1) transformation }
\item{\code{"none"} - }{ no transformation }
}
These methods allow visualization of both high- and low-abundance
taxa simultaneously, without complaint about 'zero' count
observations. Default: \code{"sqrt"}
Use \code{xaxis.transform} or \code{yaxis.transform} to pass custom values
directly to ggplot2's \verb{scale_*} functions.}

\item{flip}{Transpose the axes, so that taxa are present as rows instead
of columns. Default: \code{FALSE}}

\item{stripe}{Shade every other x position. Default: \emph{same as flip}}

\item{ci}{How to calculate min/max of the \bold{crossbar},
\bold{errorbar}, \bold{linerange}, and \bold{pointrange} layers.
Options are: \code{"ci"} (confidence interval), \code{"range"},
\code{"sd"} (standard deviation), \code{"se"} (standard error), and
\code{"mad"} (median absolute deviation).
The center mark of \bold{crossbar} and \bold{pointrange} represents
the mean, except for \code{"mad"} in which case it represents the median.
Default: \code{"ci"}}

\item{p.label}{Minimum adjusted p-value to display on the plot with a
bracket.
\describe{
\item{\code{p.label = 0.05} - }{ Show p-values that are <= 0.05. }
\item{\code{p.label = 0} - }{ Don't show any p-values on the plot. }
\item{\code{p.label = 1} - }{ Show all p-values on the plot. }
}
If a numeric vector with more than one value is
provided, they will be used as breaks for asterisk notation.
Default: \code{0.05}}

\item{level}{The confidence level for calculating a confidence interval.
Default: \code{0.95}}

\item{caption}{Add methodology caption beneath the plot.
Default: \code{TRUE}}

\item{outliers}{Show boxplot outliers? \code{TRUE} to always show.
\code{FALSE} to always hide. \code{NULL} to only hide them when
overlaying a dot or strip chart.  Default: \code{NULL}}

\item{xlab.angle}{Angle of the labels at the bottom of the plot.
Options are \code{"auto"}, \code{'0'}, \code{'30'}, and \code{'90'}.
Default: \code{"auto"}.}

\item{k}{Number of ordination dimensions to return. Either \code{2L} or
\code{3L}. Default: \code{2L}}

\item{split.by}{Dataset field(s) that the data should be split by prior to
any calculations. Must be categorical. Default: \code{NULL}}

\item{dm}{A \code{dist}-class distance matrix, as returned from
\code{\link[=bdiv_distmat]{bdiv_distmat()}} or \code{\link[stats:dist]{stats::dist()}}. Required.}

\item{groups}{A named vector of grouping values. The names should
correspond to \code{attr(dm, 'Labels')}. Values can be either
categorical or numeric. Required.}

\item{df}{The dataset (data.frame or tibble object). "Dataset fields"
mentioned below should match column names in \code{df}. Required.}

\item{regr}{Dataset field with the x-axis (independent; predictive)
values. Must be numeric. Default: \code{NULL}}

\item{resp}{Dataset field with the y-axis (dependent; response) values,
such as taxa abundance or alpha diversity.
Default: \code{attr(df, 'response')}}

\item{stat.by}{Dataset field with the statistical groups. Must be
categorical. Default: \code{NULL}}

\item{color.by}{Dataset field with the group to color by. Must be
categorical. Default: \code{stat.by}}

\item{shape.by}{Dataset field with the group for shapes. Must be
categorical. Default: \code{stat.by}}

\item{facet.by}{Dataset field(s) to use for faceting. Must be categorical.
Default: \code{NULL}}

\item{colors}{How to color the groups. Options are:
\describe{
\item{\code{TRUE} - }{ Automatically select colorblind-friendly colors. }
\item{\code{FALSE} or \code{NULL} - }{ Don't use colors. }
\item{a palette name - }{ Auto-select colors from this set. E.g. \code{"okabe"} }
\item{character vector - }{ Custom colors to use. E.g. \code{c("red", "#00FF00")} }
\item{named character vector - }{ Explicit mapping. E.g. \code{c(Male = "blue", Female = "red")} }
}
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{shapes}{Shapes for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, shape
names (typically integers 0 - 17), or a named vector mapping
groups to specific shape names.
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{patterns}{Patterns for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, pattern
names (\code{"brick"}, \code{"chevron"}, \code{"fish"}, \code{"grid"}, etc), or a named
vector mapping groups to specific pattern names.
See "Aesthetics" section below for additional information.
Default: \code{FALSE}}

\item{test}{Method for computing p-values: \code{'wilcox'}, \code{'kruskal'},
\code{'emmeans'}, or \code{'emtrends'}. Default: \code{'emmeans'}}

\item{fit}{How to fit the trendline. \code{'lm'}, \code{'log'}, or \code{'gam'}.
Default: \code{'gam'}}

\item{at}{Position(s) along the x-axis where the means or slopes should be
evaluated. Default: \code{NULL}, which samples 100 evenly spaced positions
and selects the position where the p-value is most significant.}

\item{alt}{Alternative hypothesis direction. Options are \code{'!='}
(two-sided; not equal to \code{mu}), \code{'<'} (less than \code{mu}), or \code{'>'}
(greater than \code{mu}). Default: \code{'!='}}

\item{mu}{Reference value to test against. Default: \code{0}}

\item{check}{Generate additional plots to aid in assessing data normality.
Default: \code{FALSE}}

\item{within, between}{Dataset field(s) for intra- or inter- sample
comparisons. Alternatively, dataset field names given elsewhere can
be prefixed with \code{'=='} or \code{'!='} to assign them to \code{within} or
\code{between}, respectively. Default: \code{NULL}}

\item{seed}{Random seed for permutations. Default: \code{0}}

\item{cpus}{The number of CPUs to use. Set to \code{-1} to use all available, or
to \code{0} to not use threaded computing. Default: \code{-1}}

\item{permutations}{Number of random permutations to use.
Default: \code{999}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}

\item{depths}{Rarefaction depths to show in the plot, or \code{NULL} to
auto-select. Default: \code{NULL}}

\item{rline}{Where to draw a horizontal line on the plot, intended to show
a particular rarefaction depth. Set to \code{TRUE} to show an
auto-selected rarefaction depth or \code{FALSE} to not show a line.
Default: \code{NULL}}

\item{clone}{Create a copy of \code{biom} before modifying. If \code{FALSE}, \code{biom}
is modified in place as a side-effect. See \link[=speed]{speed ups} for
use cases. Default: \code{TRUE}}

\item{labels}{Show sample names under each bar. Default: \code{FALSE}}

\item{transform}{Transformation to apply. Options are:
\code{c("none", "rank", "log", "log1p", "sqrt", "percent")}. \code{"rank"} is
useful for correcting for non-normally distributions before applying
regression statistics. Default: \code{"none"}}

\item{ties}{When \code{transform="rank"}, how to rank identical values.
Options are: \code{c("average", "first", "last", "random", "max", "min")}.
See \code{rank()} for details. Default: \code{"random"}}
}
\description{
documentation_default
}
\keyword{internal}
