% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/booster.R
\name{booster}
\alias{booster}
\title{AdaBoost Framework for Any Classifier}
\usage{
booster(
  x_train,
  y_train,
  classifier = NULL,
  predicter = NULL,
  x_test = NULL,
  y_test = NULL,
  weighted_bootstrap = FALSE,
  max_iter = 30,
  lambda = 1,
  print_detail = TRUE,
  print_plot = FALSE,
  bag_frac = 0.5,
  ...
)
}
\arguments{
\item{x_train}{feature matrix. Class depends on the classifier implemented.}

\item{y_train}{a factor class variable. Boosting algorithm allows for
k >= 2. However, not all classifiers are capable of multiclass
classification.}

\item{classifier}{pre-ready or a custom classifier function. Pre-ready
classifiers are "rpart", "glm", "nb", "earth".}

\item{predicter}{prediction function for classifier. It's output must be a
factor
variable with the same levels of y_train}

\item{x_test}{optional test feature matrix. Can be used instead of predict
function. print_detail and print_plot gives information about test.}

\item{y_test}{optional a factor test class variable with the same levels as
y_train. Can be used instead of predict function. print_detail and print_plot
gives information about test.}

\item{weighted_bootstrap}{If classifier does not support case weights,
weighted_bootstrap must be TRUE used for weighting. If classifier supports
weights, it must be FALSE. default is FALSE.}

\item{max_iter}{maximum number of iterations. Default to 30. Probably should
be higher for classifiers other than decision tree.}

\item{lambda}{a parameter for alpha weights. Should be a small
value for fast fitting classifiers. Can be chosen high for slow fitting
classifiers. Default to 1, which has no effect.}

\item{print_detail}{a logical for printing errors for each iteration.
Default to TRUE}

\item{print_plot}{a logical for plotting errors. Default to FALSE.}

\item{bag_frac}{a value between 0 and 1. It represents the proportion of
cases to be used in each iteration. Smaller datasets may be better to create
weaker classifiers. 1 means all cases. Default to 0.5.}

\item{...}{extra control for classifier and predicter functions.
weak classifiers.}
}
\value{
a booster object with below components.
 \item{n_train}{Number of cases in the input dataset.}
 \item{w}{Case weights for the final boost.}
 \item{p}{Number of features.}
 \item{weighted_bootstrap}{TRUE if weighted bootstrap applied. Otherwise FALSE.}
 \item{max_iter}{Maximum number of boosting steps.}
 \item{lambda}{The multiplier of model weights.}
 \item{predicter}{Function for prediction}
 \item{alpha}{Model weights.}
 \item{err_train}{A vector of train errors in each step of boosting.}
 \item{err_test}{A vector of test errors in each step of boosting. If there are
 no test data, it returns NULL}
 \item{models}{Models obtained in each boosting step}
 \item{x_classes}{A list of datasets, which are \code{x_train} separated for
 each class.}
 \item{n_classes}{Number of cases for each class in input dataset.}
 \item{k_classes}{Number of classes in class variable.}
 \item{bag_frac}{Proportion of input dataset used in each boosting step.}
 \item{class_names}{Names of classes in class variable.}
}
\description{
This function allows you to use any classifier to be used in
Discrete AdaBoost
framework.
}
\details{
\code{booster} can only use Discrete AdaBoost algorithm for now. It is
capable of multiclass classification using SAMME algorithm.

Pre-ready classifiers are "rpart", "glm", "nb", "earth", which means
CART, logistic regression, naive bayes and MARS classifier respectively.
\code{predicter} is valid only if a custom \code{classifier} function is
given. A custom classifier funtion should be as \code{function(x_train, y_train,
weights, ...)} and its output is a model object which can be placed in
\code{predicter}. \code{predicter} function is \code{function(model, x_new,
...)} and its output must be a vector of class predictions. See
\code{vignette("booster", package = "booster")} for examples.

\code{lambda} is a multiplier of model weights, alpha,
alpha_i=lambda x 0.5 x log((1-err_i)/err_i).

\code{weighted_bootstrap} is for bootstrap sampling in each step. If the
classifier accepts weights then it is better to turn it off. If classifier
does not accept case weights, then weighted bootstrap will make it into
weighted classifier. Learning may be slower this way.

\code{bag_frac} helps a classifier to be "weaker" by reducing sample
size. Stronger classifiers may require lower proportions of \code{bag_frac}.
}
\examples{
#To see examples, please run vignette("booster", package = "rbooster")

}
\references{
Freund, Y., & Schapire, R. E. (1997). A decision-theoretic generalization of
on-line learning and an application to boosting. Journal of computer and
system sciences, 55(1), 119-139.

Hastie, T., Rosset, S., Zhu, J., & Zou, H. (2009). Multi-class AdaBoost.
Statistics and its Interface, 2(3), 349-360.
}
\author{
Fatih Saglam, fatih.saglam@omu.edu.tr
}
