% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{user}
\alias{user}
\alias{user_template_fun}
\alias{lio_user}
\alias{lio_user_repositories}
\alias{lio_user_pkgs}
\alias{lio_user_pkg_contributions}
\alias{lio_user_repo_contributions}
\alias{lio_user_dependencies}
\title{User}
\usage{
user_template_fun(route, pg = FALSE)

lio_user(login, key = NULL, ...)

lio_user_repositories(login, page = 1, per_page = 30, key = NULL, ...)

lio_user_pkgs(login, page = 1, per_page = 30, key = NULL, ...)

lio_user_pkg_contributions(login, page = 1, per_page = 30, key = NULL,
  ...)

lio_user_repo_contributions(login, page = 1, per_page = 30, key = NULL,
  ...)

lio_user_dependencies(login, page = 1, per_page = 30, key = NULL, ...)
}
\arguments{
\item{route, pg}{IGNORED.}

\item{login}{(character) a github login name. required}

\item{key}{your Libraries.io API key. See `Auth` section in \pkg{rbraries}
manual file. optional}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}

\item{page}{(integer) page to return. Default: 1}

\item{per_page}{(integer) number of records to return per page. 
Maximum: 100. Default: 30}
}
\description{
User
}
\examples{
\dontrun{
# user info
lio_user('ropensci')

# repositories
lio_user_repositories('ropensci', per_page = 3)

# packages/projects
lio_user_pkgs('ropensci', per_page = 3)

# package/project contributions
lio_user_pkg_contributions('sckott', per_page = 3)

# contributions
lio_user_repo_contributions('sckott', per_page = 3)

# dependencies
lio_user_dependencies('ropensci', per_page = 3)
}
}
