% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkRpcs.R
\name{disconnectnode}
\alias{disconnectnode}
\title{RPC-JSON API: disconnectnode}
\usage{
disconnectnode(con, address = NULL, nodeid = NULL)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{address}{\code{character} the IP address/port
of the node.}

\item{nodeid}{\code{character} The node ID
(see \code{getpeerinfo()} for node IDs).}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Immediately disconnects from the specified peer node.
Strictly one out of \code{address} and \code{nodeid} can be
provided to identify the node.
}
\references{
\url{https://bitcoin.org/en/developer-reference#disconnectnode},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Network RPCs: \code{\link{addnode}},
  \code{\link{clearbanned}},
  \code{\link{getaddednodeinfo}},
  \code{\link{getconnectioncount}},
  \code{\link{getnettotals}}, \code{\link{getnetworkinfo}},
  \code{\link{getpeerinfo}}, \code{\link{listbanned}},
  \code{\link{ping}}, \code{\link{setnetworkactive}}
}
\author{
Bernhard Pfaff
}
\concept{Network RPCs}
