% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllipticCurves.R
\name{ecpoint}
\alias{ecpoint}
\title{Creating objects of class ECPOINT}
\usage{
ecpoint(ecparam = NULL, x, y, r = NULL)
}
\arguments{
\item{ecparam}{\code{integerECPARAM}}

\item{x}{x-coordinate, to be coercible to \code{bigz}.}

\item{y}{y-coordinate, to be coercible to \code{bigz}.}

\item{r}{the order of the base point.}
}
\value{
An object of S4-class \code{ECPOINT}
}
\description{
This function returns an object of S4-class \code{ECPOINT},
that does represent a point on an elliptic curve.
}
\examples{
p <- "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F"
b <- "0x0000000000000000000000000000000000000000000000000000000000000007"
a <- "0x0000000000000000000000000000000000000000000000000000000000000000"
r <- "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141"
x <- "0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798"
y <- "0x483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8"
curve256 <- ecparam(p, a, b)
ecp <- ecpoint(curve256, x, y, r)
ecp
}
\references{
\url{https://en.bitcoin.it/wiki/Secp256k1}
}
\seealso{
Other EllipticCurve: \code{\link{ECPARAM-class}},
  \code{\link{ECPOINT-class}},
  \code{\link{EcparamOrNull-class}},
  \code{\link{containsPoint}}, \code{\link{ecoperators}},
  \code{\link{ecparam}}, \code{\link{isNull}}
}
\author{
Bernhard Pfaff
}
\concept{EllipticCurve}
