% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sky_grid_segmentation.R
\name{sky_grid_segmentation}
\alias{sky_grid_segmentation}
\title{Sky grid segmentation}
\usage{
sky_grid_segmentation(z, a, angle_width, sequential = FALSE)
}
\arguments{
\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{angle_width}{Numeric vector of length one. It should be \code{30, 15,
10, 7.5, 6, 5, 3.75, 3, 2.5, 1.875, 1} or \code{0.5} degrees. This
constrain is rooted in the requirement of a value able to divide both the
\code{0} to \code{360} and \code{0} to \code{90} ranges into a whole number
of segments.}

\item{sequential}{Logical vector of length one. If it is \code{TRUE}, the
segments are labeled with sequential numbers. By default (\code{FALSE}),
labeling numbers are not sequential (see Details).}
}
\value{
An object from the class \linkS4class{SpatRaster} with segments
  shaped like windshields, though some of them will look elongated in
  height. The pattern is two opposite and converging straight sides and two
  opposite and parallel curvy sides.
}
\description{
Segmenting the hemisphere view into segments of equal angular resolution for
both zenith and azimuth angles.
}
\details{
Intersecting rings with sectors makes a grid in which each cell is a
portion of the hemisphere. Each pixel of the grid is labeled with an ID that
codify both ring and sector IDs. For example, a grid with a regular interval
of one degree has segment from \code{1001} to \code{360090}. This numbers are
calculated with: \code{sectorID * 1000 + ringsID}, where \code{sectorID} is
the ID number of the sector and \code{ringsID} is the ID number of the ring.
}
\examples{
z <- zenith_image(1490, lens())
a <- azimuth_image(z)
g <- sky_grid_segmentation(z, a, 15)
plot(g == 24005)
\dontrun{
g <- sky_grid_segmentation(z, a, 15, sequential = TRUE)
col <- terra::unique(g) \%>\% nrow() \%>\% rainbow() \%>\% sample()
plot(g, col = col)
}
}
\seealso{
Other Segmentation Functions: 
\code{\link{chessboard}()},
\code{\link{mask_hs}()},
\code{\link{mask_sunlit_canopy}()},
\code{\link{polar_qtree}()},
\code{\link{qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sectors_segmentation}()}
}
\concept{Segmentation Functions}
