% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_sky_points.R
\name{write_sky_points}
\alias{write_sky_points}
\title{Write sky points}
\usage{
write_sky_points(sky_points, path_to_HSP_project, img_name)
}
\arguments{
\item{sky_points}{An object of the class \emph{data.frame}. The result of a
calling to \code{\link{extract_sky_points}}.}

\item{path_to_HSP_project}{Character vector of length one. Path to the HSP
project folder. For instance,
"C:/Users/johndoe/Documents/HSP/Projects/my_prj/".}

\item{img_name}{Character vector of length one. For instance, "DSCN6342.pgm"
or "DSCN6342". See details.}
}
\value{
None. A file will be written in the HSP project folder.
}
\description{
Create a special file to interface with the HSP software.
}
\details{
This function is part of a workflow that connects this package with the HSP
software package \insertCite{Lang2013}{rcaiman}.

This function was designed to be called after
\code{\link{extract_sky_points}}. The \code{r} argument provided to
\code{\link{extract_sky_points}} should be an image pre-processed by the HSP
software. Those images are stored as PGM files in the subfolder "manipulate"
of the project folder (which will be in turn a subfolder of the
"project\strong{s}" folder). Those PGM files can be read with
\code{\link{read_caim}}.

The \code{img_name} argument of \code{write_sky_points()} should be the name
of the file associated to the aforementioned \code{r} argument.

The following code exemplifies how this package can be used in conjunction
with the HSP software. The code assumes that the user is working within an
RStudio project located in the HSP project folder.

\preformatted{
r <- read_caim("manipulate/IMG_1014.pgm") %>% normalize()
plot(r)
z <- zenith_image(ncol(r), lens())
a <- azimuth_image(z)
g <- sky_grid_segmentation(z, a, 10)
mblt <- ootb_mblt(r, z, a)
bin <- find_sky_pixels_nonnull(r, mblt$sky_s, g)
bin <- mask_hs(z, 0, 85) & bin

sun_coord <- extract_sun_coord(r, z, a, bin, g)
write_sun_coord(sun_coord$row_col, ".", "IMG_1014")

sky_points <- extract_sky_points(r, bin, g)
write_sky_points(sky_points, ".", "IMG_1014")
}
}
\references{
\insertAllCited{}
}
\seealso{
Other HSP Functions: 
\code{\link{read_manual_input}()},
\code{\link{read_opt_sky_coef}()},
\code{\link{row_col_from_zenith_azimuth}()},
\code{\link{write_sun_coord}()},
\code{\link{zenith_azimuth_from_row_col}()}
}
\concept{HSP Functions}
