/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

final class Circle3D {
    Graphics3D g3d;
    int xCenter;
    int yCenter;
    int zCenter;
    int sizeCorrection;

    Circle3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void plotCircleCenteredClipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r = diameter + 1 >> 1;
        if (xCenter + r < 0 || xCenter - r >= this.g3d.width || yCenter + r < 0 || yCenter - r >= this.g3d.height) {
            return;
        }
        r = diameter / 2;
        this.sizeCorrection = 1 - (diameter & 1);
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.zCenter = zCenter;
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        for (int y = 0; x >= y; ++y) {
            this.plot8CircleCenteredClipped(x, y);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }

    void plotCircleCenteredUnclipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r = diameter / 2;
        this.sizeCorrection = 1 - (diameter & 1);
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.zCenter = zCenter;
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        for (int y = 0; x >= y; ++y) {
            this.plot8CircleCenteredUnclipped(x, y);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }

    private void plot8CircleCenteredClipped(int dx, int dy) {
        this.g3d.plotPixelClipped(this.xCenter + dx - this.sizeCorrection, this.yCenter + dy - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter + dx - this.sizeCorrection, this.yCenter - dy, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - dx, this.yCenter + dy - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - dx, this.yCenter - dy, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter + dy - this.sizeCorrection, this.yCenter + dx - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter + dy - this.sizeCorrection, this.yCenter - dx, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - dy, this.yCenter + dx - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelClipped(this.xCenter - dy, this.yCenter - dx, this.zCenter);
    }

    private void plot8CircleCenteredUnclipped(int dx, int dy) {
        this.g3d.plotPixelUnclipped(this.xCenter + dx - this.sizeCorrection, this.yCenter + dy - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter + dx - this.sizeCorrection, this.yCenter - dy, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - dx, this.yCenter + dy - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - dx, this.yCenter - dy, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter + dy - this.sizeCorrection, this.yCenter + dx - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter + dy - this.sizeCorrection, this.yCenter - dx, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - dy, this.yCenter + dx - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelUnclipped(this.xCenter - dy, this.yCenter - dx, this.zCenter);
    }

    private void plot8FilledCircleCenteredClipped(int dx, int dy) {
        this.g3d.plotPixelsClipped(2 * dx + 1 - this.sizeCorrection, this.xCenter - dx, this.yCenter + dy - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsClipped(2 * dx + 1 - this.sizeCorrection, this.xCenter - dx, this.yCenter - dy, this.zCenter);
        this.g3d.plotPixelsClipped(2 * dy + 1 - this.sizeCorrection, this.xCenter - dy, this.yCenter + dx - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsClipped(2 * dy + 1 - this.sizeCorrection, this.xCenter - dy, this.yCenter - dx, this.zCenter);
    }

    private void plot8FilledCircleCenteredUnclipped(int dx, int dy) {
        this.g3d.plotPixelsUnclipped(2 * dx + 1 - this.sizeCorrection, this.xCenter - dx, this.yCenter + dy - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsUnclipped(2 * dx + 1 - this.sizeCorrection, this.xCenter - dx, this.yCenter - dy, this.zCenter);
        this.g3d.plotPixelsUnclipped(2 * dy + 1 - this.sizeCorrection, this.xCenter - dy, this.yCenter + dx - this.sizeCorrection, this.zCenter);
        this.g3d.plotPixelsUnclipped(2 * dy + 1 - this.sizeCorrection, this.xCenter - dy, this.yCenter - dx, this.zCenter);
    }

    void plotFilledCircleCenteredClipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r = diameter / 2;
        this.sizeCorrection = 1 - (diameter & 1);
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.zCenter = zCenter;
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        for (int y = 0; x >= y; ++y) {
            this.plot8FilledCircleCenteredClipped(x, y);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }

    void plotFilledCircleCenteredUnclipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r = diameter / 2;
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.zCenter = zCenter;
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        for (int y = 0; x >= y; ++y) {
            this.plot8FilledCircleCenteredUnclipped(x, y);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }
}

