/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;

public class SmilesAtom {
    private int number;
    private String symbol;
    private int atomicMass;
    private int charge;
    private int hydrogenCount;
    private int matchingAtom;
    private String chiralClass;
    private int chiralOrder;
    private SmilesBond[] bonds;
    private int bondsCount;
    private static final int INITIAL_BONDS = 4;
    public static final String DEFAULT_CHIRALITY = "";
    public static final String CHIRALITY_ALLENE = "AL";
    public static final String CHIRALITY_OCTAHEDRAL = "OH";
    public static final String CHIRALITY_SQUARE_PLANAR = "SP";
    public static final String CHIRALITY_TETRAHEDRAL = "TH";
    public static final String CHIRALITY_TRIGONAL_BIPYRAMIDAL = "TB";

    public SmilesAtom(int number) {
        this.number = number;
        this.symbol = null;
        this.atomicMass = Integer.MIN_VALUE;
        this.charge = 0;
        this.hydrogenCount = Integer.MIN_VALUE;
        this.matchingAtom = -1;
        this.chiralClass = null;
        this.chiralOrder = Integer.MIN_VALUE;
        this.bonds = new SmilesBond[4];
        this.bondsCount = 0;
    }

    public void createMissingHydrogen(SmilesMolecule molecule) {
        int i;
        int count = 0;
        if (this.hydrogenCount == Integer.MIN_VALUE) {
            if (this.symbol != null) {
                if (this.symbol == "B") {
                    count = 3;
                } else if (this.symbol == "Br") {
                    count = 1;
                } else if (this.symbol == "C") {
                    count = 4;
                } else if (this.symbol == "Cl") {
                    count = 1;
                } else if (this.symbol == "F") {
                    count = 1;
                } else if (this.symbol == "I") {
                    count = 1;
                } else if (this.symbol == "N") {
                    count = 3;
                } else if (this.symbol == "O") {
                    count = 2;
                } else if (this.symbol == "P") {
                    count = 3;
                } else if (this.symbol == "S") {
                    count = 2;
                }
            }
            block5: for (i = 0; i < this.bondsCount; ++i) {
                SmilesBond bond = this.bonds[i];
                switch (bond.getBondType()) {
                    case 1: 
                    case 5: 
                    case 6: {
                        --count;
                        continue block5;
                    }
                    case 2: {
                        count -= 2;
                        continue block5;
                    }
                    case 3: {
                        count -= 3;
                    }
                }
            }
        } else {
            count = this.hydrogenCount;
        }
        for (i = 0; i < count; ++i) {
            SmilesAtom hydrogen = molecule.createAtom();
            molecule.createBond(this, hydrogen, 1);
            hydrogen.setSymbol("H");
        }
    }

    public int getNumber() {
        return this.number;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol != null ? symbol.intern() : null;
    }

    public int getAtomicMass() {
        return this.atomicMass;
    }

    public void setAtomicMass(int mass) {
        this.atomicMass = mass;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public int getMatchingAtom() {
        return this.matchingAtom;
    }

    public void setMatchingAtom(int atom) {
        this.matchingAtom = atom;
    }

    public String getChiralClass() {
        return this.chiralClass;
    }

    public void setChiralClass(String chiralClass) {
        this.chiralClass = chiralClass != null ? chiralClass.intern() : null;
    }

    public int getChiralOrder() {
        return this.chiralOrder;
    }

    public void setChiralOrder(int chiralOrder) {
        this.chiralOrder = chiralOrder;
    }

    public int getHydrogenCount() {
        return this.hydrogenCount;
    }

    public void setHydrogenCount(int count) {
        this.hydrogenCount = count;
    }

    public int getBondsCount() {
        return this.bondsCount;
    }

    public SmilesBond getBond(int number) {
        if (number >= 0 && number < this.bondsCount) {
            return this.bonds[number];
        }
        return null;
    }

    public void addBond(SmilesBond bond) {
        if (this.bondsCount >= this.bonds.length) {
            SmilesBond[] tmp = new SmilesBond[this.bonds.length * 2];
            System.arraycopy(this.bonds, 0, tmp, 0, this.bonds.length);
            this.bonds = tmp;
        }
        this.bonds[this.bondsCount] = bond;
        ++this.bondsCount;
    }
}

