/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import org.jmol.util.Logger;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Viewer;

class AminoMonomer
extends AlphaMonomer {
    static final byte[] interestingAminoAtomIDs = new byte[]{2, -41, 1, 3, -33, -42};

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        byte[] offsets = AminoMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingAminoAtomIDs);
        if (offsets == null) {
            return null;
        }
        if (specialAtomIndexes[40] < 0) {
            int carbonylOxygenIndex = specialAtomIndexes[41];
            Logger.debug("I see someone who does not have a carbonyl oxygen");
            if (carbonylOxygenIndex < 0) {
                return null;
            }
            offsets[1] = (byte)(carbonylOxygenIndex - firstAtomIndex);
        }
        if (atoms[firstAtomIndex].isHetero() && !AminoMonomer.isBondedCorrectly(firstAtomIndex, offsets, atoms)) {
            return null;
        }
        AminoMonomer aminoMonomer = new AminoMonomer(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        return aminoMonomer;
    }

    static boolean isBondedCorrectly(int offset1, int offset2, int firstAtomIndex, byte[] offsets, Atom[] atoms) {
        int atomIndex1 = firstAtomIndex + (offsets[offset1] & 0xFF);
        int atomIndex2 = firstAtomIndex + (offsets[offset2] & 0xFF);
        if (atomIndex1 >= atomIndex2) {
            return false;
        }
        return atoms[atomIndex1].isBonded(atoms[atomIndex2]);
    }

    static boolean isBondedCorrectly(int firstAtomIndex, byte[] offsets, Atom[] atoms) {
        return AminoMonomer.isBondedCorrectly(2, 0, firstAtomIndex, offsets, atoms) && AminoMonomer.isBondedCorrectly(0, 3, firstAtomIndex, offsets, atoms) && AminoMonomer.isBondedCorrectly(3, 1, firstAtomIndex, offsets, atoms);
    }

    AminoMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    boolean isAminoMonomer() {
        return true;
    }

    Atom getNitrogenAtom() {
        return this.getAtomFromOffsetIndex(2);
    }

    Point3f getNitrogenAtomPoint() {
        return this.getAtomPointFromOffsetIndex(2);
    }

    Atom getCarbonylCarbonAtom() {
        return this.getAtomFromOffsetIndex(3);
    }

    Point3f getCarbonylCarbonAtomPoint() {
        return this.getAtomPointFromOffsetIndex(3);
    }

    Atom getCarbonylOxygenAtom() {
        return this.getWingAtom();
    }

    Point3f getCarbonylOxygenAtomPoint() {
        return this.getWingAtomPoint();
    }

    Atom getInitiatorAtom() {
        return this.getNitrogenAtom();
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[4] != -1 ? 4 : 3);
    }

    Atom getAtom(byte specialAtomID) {
        return this.getSpecialAtom(interestingAminoAtomIDs, specialAtomID);
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return this.getSpecialAtomPoint(interestingAminoAtomIDs, specialAtomID);
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof AminoMonomer)) {
            return false;
        }
        AminoMonomer other = (AminoMonomer)possiblyPreviousMonomer;
        return other.getCarbonylCarbonAtom().isBonded(this.getNitrogenAtom());
    }

    void findNearestAtomIndex(int x, int y, Closest closest, short madBegin, short madEnd) {
        Atom alpha;
        int radiusEnd;
        Viewer viewer = this.chain.frame.viewer;
        Atom competitor = closest.atom;
        Atom nitrogen = this.getNitrogenAtom();
        int marBegin = madBegin / 2;
        if (marBegin < 1200) {
            marBegin = 1200;
        }
        if (nitrogen.getScreenZ() == 0) {
            return;
        }
        int radiusBegin = viewer.scaleToScreen(nitrogen.getScreenZ(), marBegin);
        if (radiusBegin < 4) {
            radiusBegin = 4;
        }
        Atom ccarbon = this.getCarbonylCarbonAtom();
        int marEnd = madEnd / 2;
        if (marEnd < 1200) {
            marEnd = 1200;
        }
        if ((radiusEnd = viewer.scaleToScreen(nitrogen.getScreenZ(), marEnd)) < 4) {
            radiusEnd = 4;
        }
        if ((alpha = this.getLeadAtom()).isCursorOnTop(x, y, (radiusBegin + radiusEnd) / 2, competitor) || nitrogen.isCursorOnTop(x, y, radiusBegin, competitor) || ccarbon.isCursorOnTop(x, y, radiusEnd, competitor)) {
            closest.atom = alpha;
        }
    }
}

