/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jmol.util.Logger;

public class FileDropper
implements DropTargetListener {
    private String fd_oldFileName = "";
    private PropertyChangeSupport fd_propSupport = new PropertyChangeSupport(this);
    public static final String FD_PROPERTY_FILENAME = "filename";
    public static final String FD_PROPERTY_INLINE = "inline";

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.fd_propSupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.fd_propSupport.removePropertyChangeListener(l);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        System.out.println("DropOver detected...");
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        System.out.println("DropEnter detected...");
        dtde.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dtde) {
        System.out.println("DropExit detected...");
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        System.out.println("Drop detected...");
        Transferable t = dtde.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrop(3);
            Object o = null;
            try {
                o = t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
                Logger.error(null, ufe);
            }
            catch (IOException ioe) {
                Logger.error(null, ioe);
            }
            if (o != null && o instanceof List) {
                List fileList = (List)o;
                int length = fileList.size();
                for (int i = 0; i < length; ++i) {
                    File f = (File)fileList.get(i);
                    PropertyChangeEvent pce = new PropertyChangeEvent(this, FD_PROPERTY_FILENAME, this.fd_oldFileName, f.getAbsolutePath());
                    this.fd_propSupport.firePropertyChange(pce);
                }
                dtde.getDropTargetContext().dropComplete(true);
            }
        } else {
            System.out.println("browsing supported flavours to find something useful...");
            DataFlavor[] df = t.getTransferDataFlavors();
            if (df != null && df.length > 0) {
                for (int i = 0; i < df.length; ++i) {
                    DataFlavor flavor = df[i];
                    System.out.println("df " + i + " flavor " + flavor);
                    System.out.println("  class: " + flavor.getRepresentationClass().getName());
                    System.out.println("  mime : " + flavor.getMimeType());
                    if (flavor.getMimeType().startsWith("text/uri-list") && flavor.getRepresentationClass().getName().equals("java.lang.String")) {
                        dtde.acceptDrop(3);
                        Object o = null;
                        try {
                            o = t.getTransferData(flavor);
                        }
                        catch (UnsupportedFlavorException ufe) {
                            Logger.error(null, ufe);
                        }
                        catch (IOException ioe) {
                            Logger.error(null, ioe);
                        }
                        if (o != null && o instanceof String) {
                            System.out.println("  String: " + o.toString());
                            PropertyChangeEvent pce = new PropertyChangeEvent(this, FD_PROPERTY_FILENAME, this.fd_oldFileName, o.toString());
                            this.fd_propSupport.firePropertyChange(pce);
                            dtde.getDropTargetContext().dropComplete(true);
                        }
                        return;
                    }
                    if (!flavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) continue;
                    dtde.acceptDrop(3);
                    Object o = null;
                    try {
                        o = t.getTransferData(df[i]);
                    }
                    catch (UnsupportedFlavorException ufe) {
                        Logger.error(null, ufe);
                    }
                    catch (IOException ioe) {
                        Logger.error(null, ioe);
                    }
                    if (o != null && o instanceof String) {
                        String content = (String)o;
                        System.out.println("  String: " + content);
                        if (content.startsWith("file:/")) {
                            PropertyChangeEvent pce = new PropertyChangeEvent(this, FD_PROPERTY_FILENAME, this.fd_oldFileName, content);
                            this.fd_propSupport.firePropertyChange(pce);
                        } else {
                            PropertyChangeEvent pce = new PropertyChangeEvent(this, FD_PROPERTY_INLINE, this.fd_oldFileName, content);
                            this.fd_propSupport.firePropertyChange(pce);
                        }
                        dtde.getDropTargetContext().dropComplete(true);
                    }
                    return;
                }
            }
            dtde.rejectDrop();
        }
    }
}

