/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.lang.reflect.Field;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.openscience.cdk.applications.jchempaint.JCPLocalizationHandler;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.jchempaint.StringHelper;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.tools.LoggingTool;

public class JChemPaintMenuBar
extends JMenuBar {
    private static final long serialVersionUID = -8358165408129203644L;
    private LoggingTool logger = new LoggingTool((Object)this);
    private String guiString = "stable";

    public JChemPaintMenuBar(JChemPaintPanel jcpPanel) {
        this(jcpPanel, "stable");
    }

    public JChemPaintMenuBar(JChemPaintPanel jcpPanel, String guiString) {
        this(jcpPanel, null, guiString);
    }

    public JChemPaintMenuBar(JChemPaintPanel jcpPanel, String menuDefinition, String guiString) {
        this.guiString = guiString;
        this.createMenubar(jcpPanel, menuDefinition);
    }

    protected void createMenubar(JChemPaintPanel jcpPanel, String menuDefinition) {
        this.addNormalMenuBar(jcpPanel, menuDefinition);
        this.add(Box.createHorizontalGlue());
        this.add(this.createMenu(jcpPanel, "help"));
    }

    private void addNormalMenuBar(JChemPaintPanel jcpPanel, String menuDefinition) {
        String definition = menuDefinition;
        if (definition == null) {
            definition = this.getMenuResourceString("menubar");
        }
        String[] menuKeys = StringHelper.tokenize(definition);
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(jcpPanel, menuKeys[i]);
            if (m == null) continue;
            this.add(m);
        }
    }

    public JMenu getMenuForEmbedded(JChemPaintPanel jcpPanel) {
        String definition = this.getMenuResourceString("menubar");
        String[] menuKeys = StringHelper.tokenize(definition);
        JMenu superMenu = new JMenu("JChemPaint");
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(jcpPanel, menuKeys[i]);
            if (m == null) continue;
            superMenu.add(m);
        }
        return superMenu;
    }

    protected JMenu createMenu(JChemPaintPanel jcpPanel, String key) {
        this.logger.debug((Object)"Creating menu: ", (Object)key);
        String[] itemKeys = StringHelper.tokenize(this.getMenuResourceString(key));
        JMenu menu = new JMenu(JCPLocalizationHandler.getInstance().getString(key));
        for (int i = 0; i < itemKeys.length; ++i) {
            JMenuItem mi;
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (itemKeys[i].startsWith("@")) {
                JMenu me = this.createMenu(jcpPanel, itemKeys[i].substring(1));
                menu.add(me);
                continue;
            }
            if (itemKeys[i].endsWith("+")) {
                mi = this.createMenuItem(jcpPanel, itemKeys[i].substring(0, itemKeys[i].length() - 1), true, false);
                if (itemKeys[i].substring(0, itemKeys[i].length() - 1).equals("addImplHydrogen")) {
                    ((JCheckBoxMenuItem)mi).setSelected(true);
                }
                if (itemKeys[i].substring(0, itemKeys[i].length() - 1).equals("insertstructure") && !jcpPanel.guiString.equals("applet")) {
                    ((JCheckBoxMenuItem)mi).setSelected(true);
                }
                menu.add(mi);
                continue;
            }
            mi = this.createMenuItem(jcpPanel, itemKeys[i], false, false);
            menu.add(mi);
        }
        return menu;
    }

    public String getMenuResourceString(String key) {
        String str;
        try {
            str = JCPPropertyHandler.getInstance().getGUIDefinition(this.guiString).getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private void addShortCuts(String cmd, JMenuItem mi, JChemPaintPanel jcp) {
        Properties shortCutProps = JCPPropertyHandler.getInstance().getJCPShort_Cuts();
        String shortCuts = shortCutProps.getProperty(cmd);
        String charString = null;
        if (shortCuts != null) {
            try {
                String[] scStrings = shortCuts.trim().split(",");
                if (scStrings.length > 1) {
                    charString = scStrings[1];
                    String altKey = scStrings[0] + "_MASK";
                    Field field = Class.forName("java.awt.event.InputEvent").getField(altKey);
                    int i = field.getInt(Class.forName("java.awt.event.InputEvent"));
                    mi.setAccelerator(KeyStroke.getKeyStroke((int)charString.charAt(0), i));
                    jcp.registerKeyboardAction(mi.getActionListeners()[0], charString, KeyStroke.getKeyStroke((int)charString.charAt(0), i), 2);
                } else {
                    charString = "VK_" + scStrings[0];
                    Field field = Class.forName("java.awt.event.KeyEvent").getField(charString);
                    int i = field.getInt(Class.forName("java.awt.event.KeyEvent"));
                    mi.setAccelerator(KeyStroke.getKeyStroke(i, 0));
                    jcp.registerKeyboardAction(mi.getActionListeners()[0], charString, KeyStroke.getKeyStroke(i, 0), 2);
                }
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            catch (NoSuchFieldException nsfe) {
                nsfe.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
    }

    protected JMenuItem createMenuItem(JChemPaintPanel jcpPanel, String cmd, boolean isCheckBox, boolean isChecked) {
        this.logger.debug((Object)"Creating menu item: ", (Object)cmd);
        String translation = "***" + cmd + "***";
        try {
            translation = JCPLocalizationHandler.getInstance().getString(cmd);
            this.logger.debug((Object)"Found translation: ", (Object)translation);
        }
        catch (MissingResourceException mre) {
            this.logger.error((Object)("Could not find translation for: " + cmd));
        }
        JMenuItem mi = null;
        if (isCheckBox) {
            mi = new JCheckBoxMenuItem(translation);
            mi.setSelected(isChecked);
        } else {
            mi = new JMenuItem(translation);
        }
        this.logger.debug((Object)"Created new menu item...");
        String astr = JCPPropertyHandler.getInstance().getResourceString(cmd + "Action");
        if (astr == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        JCPAction action = jcpPanel.getJCPAction().getAction(jcpPanel, astr);
        if (action != null) {
            mi.setEnabled(action.isEnabled());
            mi.addActionListener(action);
            this.logger.debug((Object)"Coupled action to new menu item...");
        } else {
            this.logger.error((Object)("Could not find JCPAction class for:" + astr));
            mi.setEnabled(false);
        }
        this.addShortCuts(cmd, mi, jcpPanel);
        return mi;
    }
}

