/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.io.Serializable;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.JCPLocalizationHandler;
import org.openscience.cdk.controller.Controller2DModel;
import org.openscience.cdk.event.ICDKChangeListener;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.tools.MFAnalyser;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class JChemPaintModel
implements Serializable,
ICDKChangeListener {
    private static final long serialVersionUID = -6072472241802965261L;
    protected transient EventListenerList changeListeners = new EventListenerList();
    private String title;
    private String[] status = new String[3];
    private String lastAction;
    private String author;
    private String software;
    private String gendate;
    private boolean isModified = false;
    private IChemModel model;
    private Renderer2DModel rendererModel;
    private Controller2DModel controllerModel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JChemPaintModel() {
        this((IChemModel)new ChemModel());
    }

    public JChemPaintModel(IChemModel chemModel) {
        Object modelTitle = chemModel.getProperty((Object)"Title");
        this.title = modelTitle == null ? JCPLocalizationHandler.getInstance().getString("Untitled-") + System.currentTimeMillis() : modelTitle.toString();
        this.model = chemModel;
        this.controllerModel = new Controller2DModel();
        this.rendererModel = new Renderer2DModel();
    }

    public void activate() {
        this.fireChange();
    }

    public void setLastAction(String s) {
        this.lastAction = s;
        this.status[1] = s;
    }

    public EventListenerList getChangeListeners() {
        return this.changeListeners;
    }

    public void setChangeListeners(EventListenerList changeListeners) {
        this.changeListeners = changeListeners;
    }

    public void addChangeListener(ChangeListener x) {
        if (this.changeListeners == null) {
            this.changeListeners = new EventListenerList();
        }
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JChemPaintModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, x);
        x.stateChanged(new ChangeEvent(this));
    }

    public void removeChangeListener(ChangeListener x) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JChemPaintModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, x);
    }

    public void fireChange(Object source) {
        ChangeEvent c = new ChangeEvent(source);
        if (this.changeListeners == null) {
            this.changeListeners = new EventListenerList();
        }
        Object[] listeners = this.changeListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? JChemPaintModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener cl = (ChangeListener)listeners[i + 1];
            cl.stateChanged(c);
        }
    }

    public void fireChange() {
        this.fireChange(this);
    }

    public String getStatus(int position) {
        String status = "";
        if (position == 0) {
            status = this.controllerModel.getDrawModeString();
        } else if (position == 1) {
            IAtomContainer wholeModel = ChemModelManipulator.getAllInOneContainer((IChemModel)this.model);
            String formula = new MFAnalyser(wholeModel, true).getHTMLMolecularFormulaWithCharge();
            int impliciths = 0;
            for (int i = 0; i < wholeModel.getAtomCount(); ++i) {
                impliciths += wholeModel.getAtom(i).getHydrogenCount();
            }
            status = "<html>" + formula + (impliciths == 0 ? "" : " (of these " + impliciths + " Hs implicit)") + "</html>";
        } else if (position == 2 && this.rendererModel.getSelectedPart() != null) {
            IAtomContainer selectedPart = this.rendererModel.getSelectedPart();
            String formula = new MFAnalyser(selectedPart, true).getHTMLMolecularFormulaWithCharge();
            status = "<html>" + formula + "</html>";
        }
        return status;
    }

    public void setStatus(String status, int position) {
        this.status[position] = status;
    }

    public void setTitle(String text) {
        this.title = text;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void resetIsModified() {
        this.isModified = false;
    }

    public String getGendate() {
        return this.gendate;
    }

    public void setGendate(String gendate) {
        this.gendate = gendate;
    }

    public String getSoftware() {
        return this.software;
    }

    public void setSoftware(String software) {
        this.software = software;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setChemModel(IChemModel chemModel) {
        this.model = chemModel;
        this.fireChange();
    }

    public IChemModel getChemModel() {
        return this.model;
    }

    public Controller2DModel getControllerModel() {
        return this.controllerModel;
    }

    public void setControllerModel(Controller2DModel controllerModel) {
        this.controllerModel = controllerModel;
    }

    public Renderer2DModel getRendererModel() {
        return this.rendererModel;
    }

    public void setRendererModel(Renderer2DModel rendererModel) {
        this.rendererModel = rendererModel;
    }

    public void stateChanged(EventObject e) {
        this.fireChange(e.getSource());
        this.isModified = true;
    }

    public String getLastAction() {
        return this.lastAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

