/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;
import org.openscience.cdk.smsd.algorithm.vflib.map.VFMapper;
import org.openscience.cdk.smsd.algorithm.vflib.query.QueryCompiler;
import org.openscience.cdk.smsd.interfaces.AbstractSubGraph;
import org.openscience.cdk.smsd.interfaces.IMCSBase;
import org.openscience.cdk.smsd.tools.MolHandler;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFlibTurboHandlerTest")
public class VFlibSubStructureHandler
extends AbstractSubGraph
implements IMCSBase {
    private static List<Map<IAtom, IAtom>> allAtomMCS = null;
    private static Map<IAtom, IAtom> atomsMCS = null;
    private static List<Map<IAtom, IAtom>> allAtomMCSCopy = null;
    private static Map<Integer, Integer> firstMCS = null;
    private static List<Map<Integer, Integer>> allMCS = null;
    private static List<Map<Integer, Integer>> allMCSCopy = null;
    private IQueryAtomContainer queryMol = null;
    private IAtomContainer mol1 = null;
    private IAtomContainer mol2 = null;
    private List<Map<INode, IAtom>> vfLibSolutions = null;
    private int vfMCSSize = -1;
    private boolean bond_Match_Flag = false;
    private static final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(VFlibSubStructureHandler.class);

    @TestMethod(value="setMCSAlgorithm")
    public VFlibSubStructureHandler() {
        allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
        allAtomMCSCopy = new ArrayList<Map<IAtom, IAtom>>();
        atomsMCS = new HashMap<IAtom, IAtom>();
        firstMCS = new TreeMap<Integer, Integer>();
        allMCS = new ArrayList<Map<Integer, Integer>>();
        allMCSCopy = new ArrayList<Map<Integer, Integer>>();
    }

    private void setFirstMappings() {
        if (!allAtomMCS.isEmpty()) {
            atomsMCS.putAll(allAtomMCS.get(0));
            firstMCS.putAll(allMCS.get(0));
        }
    }

    private boolean mcgregorFlag() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        return commonAtomCount > this.vfMCSSize && commonAtomCount > this.vfMCSSize;
    }

    @Override
    @TestMethod(value="testSet_MolHandler_MolHandler")
    public void set(MolHandler reactant, MolHandler product) {
        this.mol1 = reactant.getMolecule();
        this.mol2 = product.getMolecule();
    }

    @Override
    @TestMethod(value="testSet_IQueryAtomContainer_MolHandler")
    public void set(IQueryAtomContainer source, IAtomContainer target) {
        this.queryMol = source;
        this.mol2 = target;
    }

    private boolean hasMap(Map<Integer, Integer> map, List<Map<Integer, Integer>> mapGlobal) {
        for (Map<Integer, Integer> test : mapGlobal) {
            if (!test.equals(map)) continue;
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testGetAllAtomMapping")
    public List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return Collections.unmodifiableList(allAtomMCS);
    }

    @Override
    @TestMethod(value="testGetAllMapping")
    public List<Map<Integer, Integer>> getAllMapping() {
        return Collections.unmodifiableList(allMCS);
    }

    @Override
    @TestMethod(value="testGetFirstAtomMapping")
    public Map<IAtom, IAtom> getFirstAtomMapping() {
        return Collections.unmodifiableMap(atomsMCS);
    }

    @Override
    @TestMethod(value="testGetFirstMapping")
    public Map<Integer, Integer> getFirstMapping() {
        return Collections.unmodifiableMap(firstMCS);
    }

    private int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }

    private void searchVFMappings() {
        IQuery query2 = null;
        VFMapper mapper = null;
        this.vfLibSolutions = new ArrayList<Map<INode, IAtom>>();
        if (this.queryMol != null) {
            List<Map<INode, IAtom>> maps;
            query2 = new QueryCompiler(this.queryMol).compile();
            mapper = new VFMapper(query2);
            if (mapper.hasMap(this.getProductMol()) && (maps = mapper.getMaps(this.getProductMol())) != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true, query2);
        } else if (this.getReactantMol().getAtomCount() <= this.getProductMol().getAtomCount()) {
            List<Map<INode, IAtom>> maps;
            query2 = new QueryCompiler(this.mol1, this.isBondMatchFlag()).compile();
            mapper = new VFMapper(query2);
            if (mapper.hasMap(this.getProductMol()) && (maps = mapper.getMaps(this.getProductMol())) != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true, query2);
        } else {
            List<Map<INode, IAtom>> maps;
            query2 = new QueryCompiler(this.getProductMol(), this.isBondMatchFlag()).compile();
            mapper = new VFMapper(query2);
            if (mapper.hasMap(this.getReactantMol()) && (maps = mapper.getMaps(this.getReactantMol())) != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(false, query2);
        }
    }

    private void setVFMappings(boolean RONP, IQuery query2) {
        int counter = 0;
        for (Map<INode, IAtom> solution : this.vfLibSolutions) {
            HashMap<IAtom, IAtom> atomatomMapping = new HashMap<IAtom, IAtom>();
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            if (solution.size() > this.vfMCSSize) {
                this.vfMCSSize = solution.size();
                allAtomMCSCopy.clear();
                allMCSCopy.clear();
                counter = 0;
            }
            for (Map.Entry<INode, IAtom> mapping : solution.entrySet()) {
                IAtom qAtom = null;
                IAtom tAtom = null;
                if (RONP) {
                    qAtom = query2.getAtom(mapping.getKey());
                    tAtom = mapping.getValue();
                } else {
                    tAtom = query2.getAtom(mapping.getKey());
                    qAtom = mapping.getValue();
                }
                Integer qIndex = this.getReactantMol().getAtomNumber(qAtom);
                Integer tIndex = this.getProductMol().getAtomNumber(tAtom);
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                    indexindexMapping.put(qIndex, tIndex);
                    continue;
                }
                try {
                    throw new CDKException("Atom index pointing to NULL");
                }
                catch (CDKException ex) {
                    Logger.error(Level.SEVERE, null, ex);
                }
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, allMCSCopy) || indexindexMapping.size() != this.vfMCSSize) continue;
            allAtomMCSCopy.add(counter, atomatomMapping);
            allMCSCopy.add(counter, indexindexMapping);
            ++counter;
        }
    }

    @Override
    public boolean isSubgraph(boolean shouldMatchBonds) {
        this.setBondMatchFlag(shouldMatchBonds);
        this.searchVFMappings();
        if (!allAtomMCSCopy.isEmpty()) {
            allAtomMCS.addAll(allAtomMCSCopy);
            allMCS.addAll(allMCSCopy);
        }
        this.setFirstMappings();
        return !allMCS.isEmpty() && allMCS.iterator().next().size() == this.getReactantMol().getAtomCount();
    }

    public boolean isBondMatchFlag() {
        return this.bond_Match_Flag;
    }

    public void setBondMatchFlag(boolean shouldMatchBonds) {
        this.bond_Match_Flag = shouldMatchBonds;
    }

    private IAtomContainer getReactantMol() {
        return this.queryMol == null ? this.mol1 : this.queryMol;
    }

    private IAtomContainer getProductMol() {
        return this.mol2;
    }
}

