/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3d;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugCrystal
extends Crystal
implements ICrystal {
    private static final long serialVersionUID = -1749989529794094087L;
    static ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugCrystal.class);

    public DebugCrystal() {
    }

    public DebugCrystal(IAtomContainer container) {
        super(container);
    }

    @Override
    public void addStereoElement(IStereoElement parity) {
        logger.debug("Adding stereo element: ", parity);
        super.addStereoElement(parity);
    }

    @Override
    public Iterable<IStereoElement> stereoElements() {
        logger.debug("Getting stereo elements.");
        return super.stereoElements();
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        logger.debug("Setting atoms: ", atoms.length);
        super.setAtoms(atoms);
    }

    @Override
    public void setAtom(int number, IAtom atom) {
        logger.debug("Setting atom at: pos=" + number, " atom=" + atom);
        super.setAtom(number, atom);
    }

    @Override
    public IAtom getAtom(int number) {
        logger.debug("Getting atom at: ", number);
        return super.getAtom(number);
    }

    @Override
    public IBond getBond(int number) {
        logger.debug("Getting bond at: ", number);
        return super.getBond(number);
    }

    @Override
    public ILonePair getLonePair(int number) {
        logger.debug("Getting lone pair at: ", number);
        return super.getLonePair(number);
    }

    @Override
    public ISingleElectron getSingleElectron(int number) {
        logger.debug("Getting single electron at: ", number);
        return super.getSingleElectron(number);
    }

    @Override
    public Iterable<IAtom> atoms() {
        logger.debug("Getting atoms iterator");
        return super.atoms();
    }

    @Override
    public Iterable<IBond> bonds() {
        logger.debug("Getting bonds iterator");
        return super.bonds();
    }

    @Override
    public Iterable<ILonePair> lonePairs() {
        logger.debug("Getting lone pairs iterator");
        return super.lonePairs();
    }

    @Override
    public Iterable<ISingleElectron> singleElectrons() {
        logger.debug("Getting single electrons iterator");
        return super.singleElectrons();
    }

    @Override
    public Iterable<IElectronContainer> electronContainers() {
        logger.debug("Getting electron containers iterator");
        return super.electronContainers();
    }

    @Override
    public IAtom getFirstAtom() {
        logger.debug("Getting first atom: ", super.getFirstAtom());
        return super.getFirstAtom();
    }

    @Override
    public IAtom getLastAtom() {
        logger.debug("Getting last atom: ", super.getLastAtom());
        return super.getLastAtom();
    }

    @Override
    public int getAtomNumber(IAtom atom) {
        logger.debug("Getting atom number: ", atom);
        return super.getAtomNumber(atom);
    }

    @Override
    public int getBondNumber(IAtom atom1, IAtom atom2) {
        logger.debug("Getting bond number: atom1=" + atom1, " atom2=" + atom2);
        return super.getBondNumber(atom1, atom2);
    }

    @Override
    public int getBondNumber(IBond bond) {
        logger.debug("Getting bond number: ", bond);
        return super.getBondNumber(bond);
    }

    @Override
    public int getLonePairNumber(ILonePair bond) {
        logger.debug("Getting lone pair number: ", bond);
        return super.getLonePairNumber(bond);
    }

    @Override
    public int getSingleElectronNumber(ISingleElectron bond) {
        logger.debug("Getting single electron number: ", bond);
        return super.getSingleElectronNumber(bond);
    }

    @Override
    public IElectronContainer getElectronContainer(int number) {
        logger.debug("Getting electron container at: ", number);
        return super.getElectronContainer(number);
    }

    @Override
    public IBond getBond(IAtom atom1, IAtom atom2) {
        logger.debug("Getting bond for atoms: atom1=" + atom1, " atom2=" + atom2);
        return super.getBond(atom1, atom2);
    }

    @Override
    public int getAtomCount() {
        logger.debug("Getting atom count");
        return super.getAtomCount();
    }

    @Override
    public int getBondCount() {
        logger.debug("Getting bond count");
        return super.getBondCount();
    }

    @Override
    public int getLonePairCount() {
        logger.debug("Getting lone pair count");
        return super.getLonePairCount();
    }

    @Override
    public int getSingleElectronCount() {
        logger.debug("Getting single electron count");
        return super.getSingleElectronCount();
    }

    @Override
    public int getElectronContainerCount() {
        logger.debug("Getting electron container count");
        return super.getElectronContainerCount();
    }

    public List getConnectedAtomsList(IAtom atom) {
        logger.debug("Getting connecting atoms vector for atom: ", atom);
        return super.getConnectedAtomsList(atom);
    }

    public List getConnectedBondsList(IAtom atom) {
        logger.debug("Getting connected bonds vector for atom: ", atom);
        return super.getConnectedBondsList(atom);
    }

    public List getConnectedLonePairsList(IAtom atom) {
        logger.debug("Getting lone pairs at atom: atom=" + atom, " lone pairs=" + super.getConnectedLonePairsCount(atom));
        return super.getConnectedLonePairsList(atom);
    }

    public List getConnectedSingleElectronsList(IAtom atom) {
        logger.debug("Getting single electrons at atom: atom=" + atom, " single electrons=" + super.getConnectedSingleElectronsCount(atom));
        return super.getConnectedSingleElectronsList(atom);
    }

    public List getConnectedElectronContainersList(IAtom atom) {
        logger.debug("Getting connected electron containers for atom: ", atom);
        return super.getConnectedElectronContainersList(atom);
    }

    @Override
    public int getConnectedAtomsCount(IAtom atom) {
        logger.debug("Getting connected atoms count for atom: ", atom);
        return super.getConnectedAtomsCount(atom);
    }

    @Override
    public int getConnectedBondsCount(IAtom atom) {
        logger.debug("Getting connected bonds count for atom: ", atom);
        return super.getConnectedBondsCount(atom);
    }

    @Override
    public int getConnectedLonePairsCount(IAtom atom) {
        logger.debug("Getting connected lone pairs count for atom: ", atom);
        return super.getConnectedLonePairsCount(atom);
    }

    @Override
    public int getConnectedSingleElectronsCount(IAtom atom) {
        logger.debug("Getting connected single electrons count for atom: ", atom);
        return super.getConnectedSingleElectronsCount(atom);
    }

    @Override
    public double getBondOrderSum(IAtom atom) {
        logger.debug("Getting bond order sum for atom: ", atom);
        return super.getBondOrderSum(atom);
    }

    @Override
    public IBond.Order getMaximumBondOrder(IAtom atom) {
        logger.debug("Getting maximum bond order for atom: ", atom);
        return super.getMaximumBondOrder(atom);
    }

    @Override
    public IBond.Order getMinimumBondOrder(IAtom atom) {
        logger.debug("Getting minimum bond order for atom: ", atom);
        return super.getMinimumBondOrder(atom);
    }

    @Override
    public void add(IAtomContainer atomContainer) {
        logger.debug("Adding atom container: ", atomContainer);
        super.add(atomContainer);
    }

    @Override
    public void addAtom(IAtom atom) {
        logger.debug("Adding atom: ", atom);
        super.addAtom(atom);
    }

    @Override
    public void addBond(IBond bond) {
        logger.debug("Adding bond: ", bond);
        super.addBond(bond);
    }

    @Override
    public void addLonePair(ILonePair ec) {
        logger.debug("Adding lone pair: ", ec);
        super.addLonePair(ec);
    }

    @Override
    public void addSingleElectron(ISingleElectron ec) {
        logger.debug("Adding single electron: ", ec);
        super.addSingleElectron(ec);
    }

    @Override
    public void addElectronContainer(IElectronContainer electronContainer) {
        logger.debug("Adding electron container: ", electronContainer);
        super.addElectronContainer(electronContainer);
    }

    @Override
    public void remove(IAtomContainer atomContainer) {
        logger.debug("Removing atom container: ", atomContainer);
        super.remove(atomContainer);
    }

    @Override
    public IElectronContainer removeElectronContainer(int position) {
        logger.debug("Removing electronContainer: ", position);
        return super.removeElectronContainer(position);
    }

    @Override
    public void removeElectronContainer(IElectronContainer electronContainer) {
        logger.debug("Removing electron container: ", electronContainer);
        super.removeElectronContainer(electronContainer);
    }

    @Override
    public void removeAtom(int position) {
        logger.debug("Removing atom: ", position);
        super.removeAtom(position);
    }

    @Override
    public void removeAtom(IAtom atom) {
        logger.debug("Removing atom: ", atom);
        super.removeAtom(atom);
    }

    @Override
    public IBond removeBond(int pos) {
        logger.debug("Removing bond at " + pos);
        return super.removeBond(pos);
    }

    @Override
    public IBond removeBond(IAtom atom1, IAtom atom2) {
        logger.debug("Removing bond: atom1=" + atom1 + " atom2=" + atom2);
        return super.removeBond(atom1, atom2);
    }

    @Override
    public void removeBond(IBond bond) {
        logger.debug("Removing bond=" + bond);
        super.removeBond(bond);
    }

    @Override
    public ILonePair removeLonePair(int pos) {
        logger.debug("Removing bond at " + pos);
        return super.removeLonePair(pos);
    }

    @Override
    public void removeLonePair(ILonePair ec) {
        logger.debug("Removing bond=" + ec);
        super.removeLonePair(ec);
    }

    @Override
    public ISingleElectron removeSingleElectron(int pos) {
        logger.debug("Removing bond at " + pos);
        return super.removeSingleElectron(pos);
    }

    @Override
    public void removeSingleElectron(ISingleElectron ec) {
        logger.debug("Removing bond=" + ec);
        super.removeSingleElectron(ec);
    }

    @Override
    public void removeAtomAndConnectedElectronContainers(IAtom atom) {
        logger.debug("Removing atom and connected electron containers: ", atom);
        super.removeAtomAndConnectedElectronContainers(atom);
    }

    @Override
    public void removeAllElements() {
        logger.debug("Removing all elements");
        super.removeAllElements();
    }

    @Override
    public void removeAllElectronContainers() {
        logger.debug("Removing all electron containers");
        super.removeAllElectronContainers();
    }

    @Override
    public void removeAllBonds() {
        logger.debug("Removing all bonds");
        super.removeAllBonds();
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        logger.debug("Adding bond: atom1=" + atom1 + " atom2=" + atom2, " order=" + (Object)((Object)order) + " stereo=" + (Object)((Object)stereo));
        super.addBond(atom1, atom2, order, stereo);
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order) {
        logger.debug("Adding bond: atom1=" + atom1 + " atom2=" + atom2, " order=" + (Object)((Object)order));
        super.addBond(atom1, atom2, order);
    }

    @Override
    public void addLonePair(int atomID) {
        logger.debug("Adding lone pair: ", atomID);
        super.addLonePair(atomID);
    }

    @Override
    public void addSingleElectron(int atomID) {
        logger.debug("Adding single electron: ", atomID);
        super.addSingleElectron(atomID);
    }

    @Override
    public boolean contains(IAtom atom) {
        logger.debug("Contains atom: ", atom);
        return super.contains(atom);
    }

    @Override
    public boolean contains(IBond bond) {
        logger.debug("Contains bond: ", bond);
        return super.contains(bond);
    }

    @Override
    public boolean contains(ILonePair ec) {
        logger.debug("Contains lone pair: ", ec);
        return super.contains(ec);
    }

    @Override
    public boolean contains(ISingleElectron ec) {
        logger.debug("Contains single electron: ", ec);
        return super.contains(ec);
    }

    @Override
    public boolean contains(IElectronContainer electronContainer) {
        logger.debug("Contains electron container: ", electronContainer);
        return super.contains(electronContainer);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    public Object getProperty(Object description) {
        logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        logger.debug("Setting properties: ", properties);
        super.setProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public ICrystal clone() throws CloneNotSupportedException {
        ICrystal clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public void setA(Vector3d newAxis) {
        logger.debug("Setting A axis to: ", newAxis);
        super.setA(newAxis);
    }

    @Override
    public Vector3d getA() {
        logger.debug("Getting A axis: ", super.getA());
        return super.getA();
    }

    @Override
    public void setB(Vector3d newAxis) {
        logger.debug("Setting B axis to: ", newAxis);
        super.setB(newAxis);
    }

    @Override
    public Vector3d getB() {
        logger.debug("Getting B axis: ", super.getB());
        return super.getB();
    }

    @Override
    public void setC(Vector3d newAxis) {
        logger.debug("Setting C axis to: ", newAxis);
        super.setC(newAxis);
    }

    @Override
    public Vector3d getC() {
        logger.debug("Getting C axis: ", super.getC());
        return super.getC();
    }

    @Override
    public String getSpaceGroup() {
        logger.debug("Getting space group: ", super.getSpaceGroup());
        return super.getSpaceGroup();
    }

    @Override
    public void setSpaceGroup(String group) {
        logger.debug("Setting space group to: ", group);
        super.setSpaceGroup(group);
    }

    @Override
    public Integer getZ() {
        logger.debug("Getting Z: ", super.getZ());
        return super.getZ();
    }

    @Override
    public void setZ(Integer value) {
        logger.debug("Settting Z to: ", value);
        super.setZ(value);
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
        logger.debug("Receiving state changed: ", event);
        super.stateChanged(event);
    }

    @Override
    public boolean isEmpty() {
        logger.debug("Checking if crystal is empty: ", super.isEmpty());
        return super.isEmpty();
    }
}

