/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.IonizationPotentialTool;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.bond.IPBondLearningDescriptorTest")
public class IPBondLearningDescriptor
extends AbstractBondDescriptor {
    private static final String[] descriptorNames = new String[]{"ipBondLearning"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ionizationPotential", this.getClass().getName(), "$Id: d59094669b091a45f7bb4889c957f76cd6e5b95f $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
    }

    @TestMethod(value="testCalculate_IBond_IAtomContainer,testIPDescriptor_1,testIPDescriptor_2,testIPDescriptor_3")
    public DescriptorValue calculate(IBond bond, IAtomContainer atomContainer) {
        double value = 0.0;
        String originalAtomtypeName1 = bond.getAtom(0).getAtomTypeName();
        Integer originalNeighborCount1 = bond.getAtom(0).getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization1 = bond.getAtom(0).getHybridization();
        Integer originalValency1 = bond.getAtom(0).getValency();
        String originalAtomtypeName2 = bond.getAtom(1).getAtomTypeName();
        Integer originalNeighborCount2 = bond.getAtom(1).getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization2 = bond.getAtom(1).getHybridization();
        Integer originalValency2 = bond.getAtom(1).getValency();
        Double originalBondOrderSum1 = bond.getAtom(0).getBondOrderSum();
        IBond.Order originalMaxBondOrder1 = bond.getAtom(0).getMaxBondOrder();
        Double originalBondOrderSum2 = bond.getAtom(1).getBondOrderSum();
        IBond.Order originalMaxBondOrder2 = bond.getAtom(1).getMaxBondOrder();
        if (!this.isCachedAtomContainer(atomContainer)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(atomContainer);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        if (!bond.getOrder().equals((Object)IBond.Order.SINGLE)) {
            try {
                value = IonizationPotentialTool.predictIP(atomContainer, bond);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        bond.getAtom(0).setAtomTypeName(originalAtomtypeName1);
        bond.getAtom(0).setHybridization(originalHybridization1);
        bond.getAtom(0).setValency(originalValency1);
        bond.getAtom(0).setFormalNeighbourCount(originalNeighborCount1);
        bond.getAtom(1).setAtomTypeName(originalAtomtypeName2);
        bond.getAtom(1).setHybridization(originalHybridization2);
        bond.getAtom(1).setValency(originalValency2);
        bond.getAtom(1).setFormalNeighbourCount(originalNeighborCount2);
        bond.getAtom(0).setMaxBondOrder(originalMaxBondOrder1);
        bond.getAtom(0).setBondOrderSum(originalBondOrderSum1);
        bond.getAtom(1).setMaxBondOrder(originalMaxBondOrder2);
        bond.getAtom(1).setBondOrderSum(originalBondOrderSum2);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(value), descriptorNames);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

