/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.Edge;

public enum Bond {
    DOT(".", 0),
    IMPLICIT("", 1),
    SINGLE("-", 1),
    DOUBLE("=", 2),
    TRIPLE("#", 3),
    QUADRUPLE("$", 4),
    AROMATIC(":", 1),
    UP("/", 1){

        @Override
        public Bond inverse() {
            return DOWN;
        }

        @Override
        boolean directional() {
            return true;
        }
    }
    ,
    DOWN("\\", 1){

        @Override
        public Bond inverse() {
            return UP;
        }

        @Override
        boolean directional() {
            return true;
        }
    };

    private final String token;
    private final int order;

    private Bond(String token, int order) {
        this.token = token;
        this.order = order;
    }

    public final String token() {
        return this.token;
    }

    public int order() {
        return this.order;
    }

    public Bond inverse() {
        return this;
    }

    public Edge edge(int u, int v) {
        return new Edge(u, v, this);
    }

    boolean directional() {
        return false;
    }

    public final String toString() {
        return this.token;
    }
}

