/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.ConformerContainer")
public class ConformerContainer
implements List<IAtomContainer> {
    private IAtomContainer atomContainer = null;
    private String title = null;
    private List<Point3d[]> coordinates;

    private Point3d[] getCoordinateList(IAtomContainer atomContainer) {
        Point3d[] tmp = new Point3d[atomContainer.getAtomCount()];
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            IAtom atom = atomContainer.getAtom(i);
            if (atom.getPoint3d() == null) {
                throw new NullPointerException("Molecule must have 3D coordinates");
            }
            tmp[i] = new Point3d(atom.getPoint3d());
        }
        return tmp;
    }

    public ConformerContainer() {
        this.coordinates = new ArrayList<Point3d[]>();
    }

    public ConformerContainer(IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
        this.title = (String)atomContainer.getProperty("cdk:Title");
        this.coordinates = new ArrayList<Point3d[]>();
        this.coordinates.add(this.getCoordinateList(atomContainer));
    }

    public ConformerContainer(IAtomContainer[] atomContainers) {
        if (atomContainers.length == 0) {
            throw new IllegalArgumentException("Can't use a zero-length molecule array");
        }
        this.title = (String)atomContainers[0].getProperty("cdk:Title");
        for (IAtomContainer atomContainer : atomContainers) {
            String nextTitle = (String)atomContainer.getProperty("cdk:Title");
            if (this.title == null || nextTitle.equals(this.title)) continue;
            throw new IllegalArgumentException("Titles of all molecules must match");
        }
        this.atomContainer = atomContainers[0];
        this.coordinates = new ArrayList<Point3d[]>();
        for (IAtomContainer container : atomContainers) {
            this.coordinates.add(this.getCoordinateList(container));
        }
    }

    @TestMethod(value="testGetTitle")
    public String getTitle() {
        return this.title;
    }

    @Override
    @TestMethod(value="testSize")
    public int size() {
        return this.coordinates.size();
    }

    @Override
    @TestMethod(value="testIsEmpty")
    public boolean isEmpty() {
        return this.coordinates.isEmpty();
    }

    @Override
    @TestMethod(value="testContains, testContains_Object")
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    @TestMethod(value="testIterator, testIterator2")
    public Iterator<IAtomContainer> iterator() {
        return new CCIterator();
    }

    @Override
    @TestMethod(value="testToArray")
    public Object[] toArray() {
        Object[] ret = new IAtomContainer[this.coordinates.size()];
        int index = 0;
        for (Point3d[] coords : this.coordinates) {
            try {
                IAtomContainer conf = this.atomContainer.clone();
                for (int i = 0; i < coords.length; ++i) {
                    IAtom atom = conf.getAtom(i);
                    atom.setPoint3d(coords[i]);
                }
                ret[index++] = conf;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    @TestMethod(value="testToArray_arrayObject")
    public <IAtomContainer> IAtomContainer[] toArray(IAtomContainer[] ts) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testAdd_IAtomContainer")
    public boolean add(IAtomContainer atomContainer) {
        if (this.atomContainer == null) {
            this.atomContainer = atomContainer;
            this.title = (String)atomContainer.getProperty("cdk:Title");
        }
        if (this.title == null) {
            throw new IllegalArgumentException("At least one of the input molecules does not have a title");
        }
        if (!this.title.equals(atomContainer.getProperty("cdk:Title"))) {
            throw new IllegalArgumentException("The input molecules does not have the same title ('" + this.title + "') as the other conformers ('" + atomContainer.getProperty("cdk:Title") + "')");
        }
        if (atomContainer.getAtomCount() != this.atomContainer.getAtomCount()) {
            throw new IllegalArgumentException("Doesn't have the same number of atoms as the rest of the conformers");
        }
        this.coordinates.add(this.getCoordinateList(atomContainer));
        return true;
    }

    @Override
    @TestMethod(value="testRemove_Object")
    public boolean remove(Object o) {
        IAtomContainer atomContainer = (IAtomContainer)o;
        if (atomContainer == null) {
            return false;
        }
        int index = this.indexOf(atomContainer);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testContainsAll_Collection")
    public boolean containsAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testAddAll_Collection")
    public boolean addAll(Collection<? extends IAtomContainer> atomContainers) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testAddAll_int_Collection")
    public boolean addAll(int i, Collection<? extends IAtomContainer> iAtomContainers) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testRemoveAll_Collectio")
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testRetainAll_Collection")
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testClear")
    public void clear() {
        this.coordinates.clear();
    }

    @Override
    @TestMethod(value="testGet_int, testGet2")
    public IAtomContainer get(int i) {
        Point3d[] tmp = this.coordinates.get(i);
        for (int j = 0; j < this.atomContainer.getAtomCount(); ++j) {
            IAtom atom = this.atomContainer.getAtom(j);
            atom.setPoint3d(tmp[j]);
        }
        return this.atomContainer;
    }

    @Override
    @TestMethod(value="testSet_int_IAtomContainer")
    public IAtomContainer set(int i, IAtomContainer atomContainer) {
        if (!this.title.equals(atomContainer.getProperty("cdk:Title"))) {
            throw new IllegalArgumentException("The input molecules does not have the same title as the other conformers");
        }
        Point3d[] tmp = this.getCoordinateList(atomContainer);
        IAtomContainer oldAtomContainer = this.get(i);
        this.coordinates.set(i, tmp);
        return oldAtomContainer;
    }

    @Override
    @TestMethod(value="testAdd_int_IAtomContainer")
    public void add(int i, IAtomContainer atomContainer) {
        if (this.atomContainer == null) {
            this.atomContainer = atomContainer;
            this.title = (String)atomContainer.getProperty("cdk:Title");
        }
        if (!this.title.equals(atomContainer.getProperty("cdk:Title"))) {
            throw new IllegalArgumentException("The input molecules does not have the same title as the other conformers");
        }
        if (atomContainer.getAtomCount() != this.atomContainer.getAtomCount()) {
            throw new IllegalArgumentException("Doesn't have the same number of atoms as the rest of the conformers");
        }
        Point3d[] tmp = this.getCoordinateList(atomContainer);
        this.coordinates.add(i, tmp);
    }

    @Override
    @TestMethod(value="testRemove_int")
    public IAtomContainer remove(int i) {
        IAtomContainer oldAtomContainer = this.get(i);
        this.coordinates.remove(i);
        return oldAtomContainer;
    }

    @Override
    @TestMethod(value="testIndexOf_Object")
    public int indexOf(Object o) {
        IAtomContainer atomContainer = (IAtomContainer)o;
        if (!atomContainer.getProperty("cdk:Title").equals(this.title)) {
            return -1;
        }
        if (atomContainer.getAtomCount() != this.atomContainer.getAtomCount()) {
            return -1;
        }
        int index = 0;
        for (Point3d[] coords : this.coordinates) {
            boolean coordsMatch = true;
            for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
                Point3d p = atomContainer.getAtom(i).getPoint3d();
                if (p.x == coords[i].x && p.y == coords[i].y && p.z == coords[i].z) continue;
                coordsMatch = false;
                break;
            }
            if (coordsMatch) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    @TestMethod(value="testLastIndexOf_Object")
    public int lastIndexOf(Object o) {
        IAtomContainer atomContainer = (IAtomContainer)o;
        if (!atomContainer.getProperty("cdk:Title").equals(this.title)) {
            return -1;
        }
        if (atomContainer.getAtomCount() != this.coordinates.get(0).length) {
            return -1;
        }
        for (int j = this.coordinates.size() - 1; j >= 0; --j) {
            Point3d[] coords = this.coordinates.get(j);
            boolean coordsMatch = true;
            for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
                Point3d p = atomContainer.getAtom(i).getPoint3d();
                if (p.x == coords[i].x && p.y == coords[i].y && p.z == coords[i].z) continue;
                coordsMatch = false;
                break;
            }
            if (!coordsMatch) continue;
            return j;
        }
        return -1;
    }

    @Override
    @TestMethod(value="testListIterator")
    public ListIterator<IAtomContainer> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testListIterator_int")
    public ListIterator<IAtomContainer> listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testSubList_int_int")
    public List<IAtomContainer> subList(int i, int i1) {
        throw new UnsupportedOperationException();
    }

    private class CCIterator
    implements Iterator<IAtomContainer> {
        int current = 0;
        int last = -1;

        private CCIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current != ConformerContainer.this.coordinates.size();
        }

        @Override
        public IAtomContainer next() {
            Point3d[] tmp = (Point3d[])ConformerContainer.this.coordinates.get(this.current);
            for (int j = 0; j < ConformerContainer.this.atomContainer.getAtomCount(); ++j) {
                IAtom atom = ConformerContainer.this.atomContainer.getAtom(j);
                atom.setPoint3d(tmp[j]);
            }
            this.last = this.current++;
            return ConformerContainer.this.atomContainer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

