/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.group.IntegerInvariant;
import org.openscience.cdk.group.Invariant;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Refinable;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

class BondRefinable
implements Refinable {
    private final IAtomContainer atomContainer;
    private int[][] connectionTable;
    private boolean ignoreBondOrders;

    public BondRefinable(IAtomContainer atomContainer) {
        this(atomContainer, false);
    }

    public BondRefinable(IAtomContainer atomContainer, boolean ignoreBondOrders) {
        this.atomContainer = atomContainer;
        this.ignoreBondOrders = ignoreBondOrders;
        this.setupConnectionTable(atomContainer);
    }

    @Override
    public int getVertexCount() {
        return this.atomContainer.getBondCount();
    }

    @Override
    public int getConnectivity(int vertexI, int vertexJ) {
        int maxRowIndex = this.connectionTable[vertexI].length;
        for (int indexInRow = 0; indexInRow < maxRowIndex; ++indexInRow) {
            if (this.connectionTable[vertexI][indexInRow] != vertexJ) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Invariant neighboursInBlock(Set<Integer> block, int vertexIndex) {
        int neighbours = 0;
        for (int connected : this.getConnectedIndices(vertexIndex)) {
            if (!block.contains(connected)) continue;
            ++neighbours;
        }
        return new IntegerInvariant(neighbours);
    }

    private int[] getConnectedIndices(int vertexIndex) {
        return this.connectionTable[vertexIndex];
    }

    @Override
    public Partition getInitialPartition() {
        int bondCount = this.atomContainer.getBondCount();
        HashMap cellMap = new HashMap();
        for (int bondIndex = 0; bondIndex < bondCount; ++bondIndex) {
            SortedSet<Integer> cell;
            String boS;
            IBond bond = this.atomContainer.getBond(bondIndex);
            String el0 = bond.getAtom(0).getSymbol();
            String el1 = bond.getAtom(1).getSymbol();
            if (this.ignoreBondOrders) {
                boS = "1";
            } else {
                boolean isArom = bond.getFlag(32);
                int orderNumber = isArom ? 5 : bond.getOrder().numeric();
                boS = String.valueOf(orderNumber);
            }
            String bondString = el0.compareTo(el1) < 0 ? el0 + boS + el1 : el1 + boS + el0;
            if (cellMap.containsKey(bondString)) {
                cell = (SortedSet)cellMap.get(bondString);
            } else {
                cell = new TreeSet();
                cellMap.put(bondString, cell);
            }
            cell.add(bondIndex);
        }
        ArrayList bondStrings = new ArrayList(cellMap.keySet());
        Collections.sort(bondStrings);
        Partition bondPartition = new Partition();
        for (String key : bondStrings) {
            SortedSet cell = (SortedSet)cellMap.get(key);
            bondPartition.addCell(cell);
        }
        bondPartition.order();
        return bondPartition;
    }

    private void setupConnectionTable(IAtomContainer atomContainer) {
        int bondCount = atomContainer.getBondCount();
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        HashMap<String, Object> bondMap = new HashMap<String, Object>();
        for (int bondIndexI = 0; bondIndexI < bondCount; ++bondIndexI) {
            String boS;
            IBond bond = atomContainer.getBond(bondIndexI);
            bonds.add(bond);
            int a0 = atomContainer.indexOf(bond.getAtom(0));
            int a1 = atomContainer.indexOf(bond.getAtom(1));
            if (this.ignoreBondOrders) {
                boS = "1";
            } else {
                boolean isArom = bond.getFlag(32);
                int orderNumber = isArom ? 5 : bond.getOrder().numeric();
                boS = String.valueOf(orderNumber);
            }
            String bondString = a0 < a1 ? a0 + "," + boS + "," + a1 : a1 + "," + boS + "," + a0;
            bondMap.put(bondString, bond);
        }
        ArrayList keys = new ArrayList(bondMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            bonds.add((IBond)bondMap.get(key));
        }
        this.connectionTable = new int[bondCount][];
        for (int bondIndexI = 0; bondIndexI < bondCount; ++bondIndexI) {
            IBond bondI = (IBond)bonds.get(bondIndexI);
            ArrayList<Integer> connectedBondIndices = new ArrayList<Integer>();
            for (int bondIndexJ = 0; bondIndexJ < bondCount; ++bondIndexJ) {
                IBond bondJ;
                if (bondIndexI == bondIndexJ || !bondI.isConnectedTo(bondJ = (IBond)bonds.get(bondIndexJ))) continue;
                connectedBondIndices.add(bondIndexJ);
            }
            int connBondCount = connectedBondIndices.size();
            this.connectionTable[bondIndexI] = new int[connBondCount];
            for (int index = 0; index < connBondCount; ++index) {
                this.connectionTable[bondIndexI][index] = (Integer)connectedBondIndices.get(index);
            }
        }
    }
}

