/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.ChemObjectIO;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.IChemObjectReaderErrorHandler;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;

public abstract class DefaultIteratingChemObjectReader<T extends IChemObject>
extends ChemObjectIO
implements IIteratingChemObjectReader<T> {
    protected IChemObjectReader.Mode mode = IChemObjectReader.Mode.RELAXED;
    protected IChemObjectReaderErrorHandler errorHandler = null;

    @Override
    public boolean accepts(Class<? extends IChemObject> objectClass) {
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReaderMode(IChemObjectReader.Mode mode) {
        this.mode = mode;
    }

    @Override
    public void setErrorHandler(IChemObjectReaderErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void handleError(String message) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message);
        }
    }

    @Override
    public void handleError(String message, Exception exception) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, exception);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message, exception);
        }
    }

    @Override
    public void handleError(String message, int row, int colStart, int colEnd) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, row, colStart, colEnd);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message);
        }
    }

    @Override
    public void handleError(String message, int row, int colStart, int colEnd, Exception exception) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, row, colStart, colEnd, exception);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message, exception);
        }
    }
}

