% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-addc.R, R/cdo-divc.R, R/cdo-maxc.R,
%   R/cdo-minc.R, R/cdo-mulc.R, R/cdo-subc.R, R/family-arithc.R
\name{cdo_addc}
\alias{cdo_addc}
\alias{cdo_divc}
\alias{cdo_maxc}
\alias{cdo_minc}
\alias{cdo_mulc}
\alias{cdo_subc}
\alias{arithc}
\title{Arithmetic with a constant}
\usage{
cdo_addc(ifile, c = NULL, ofile = NULL)

cdo_divc(ifile, c = NULL, ofile = NULL)

cdo_maxc(ifile, c = NULL, ofile = NULL)

cdo_minc(ifile, c = NULL, ofile = NULL)

cdo_mulc(ifile, c = NULL, ofile = NULL)

cdo_subc(ifile, c = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{c}{FLOAT - Constant}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module performs simple arithmetic with all field elements of a dataset and a constant. The fields in outfile inherit the meta data from infile.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{addc  Add a constant
      o(t,x) = i(t,x) + c
subc  Subtract a constant
      o(t,x) = i(t,x) - c
mulc  Multiply with a constant
      o(t,x) = i(t,x) * c
divc  Divide by a constant
      o(t,x) = i(t,x) / c
minc  Minimum of a field and a constant
      o(t,x) = min(i(t,x), c)
maxc  Maximum of a field and a constant
      o(t,x) = max(i(t,x), c)
}\if{html}{\out{</div>}}
}
