% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-dv2uv.R, R/cdo-uv2dv.R, R/family-wind.R
\name{cdo_dv2uv}
\alias{cdo_dv2uv}
\alias{cdo_uv2dv}
\alias{wind}
\title{Wind transformation}
\usage{
cdo_dv2uv(ifile, gridtype = NULL, ofile = NULL)

cdo_uv2dv(ifile, gridtype = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{gridtype}{STRING - Type of the grid: quadratic, linear, cubic (default: quadratic)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module converts relative divergence and vorticity to U and V wind and vice versa. Divergence and vorticity are spherical harmonic coefficients in spectral space and U and V are on a global regular Gaussian grid. The Gaussian latitudes need to be ordered from north to south. Missing values are not supported.  The relationship between the spectral resolution, governed by the truncation number T, and the grid resolution depends on the number of grid points at which the shortest wavelength field is represented. For a grid with 2N points between the poles (so 4N grid points in total around the globe) the relationship is:  linear grid: the shortest wavelength is represented by 2 grid points → 4N \eqn{\simeq} 2(TL + 1)  quadratic grid: the shortest wavelength is represented by 3 grid points → 4N \eqn{\simeq} 3(TQ + 1)  cubic grid: the shortest wavelength is represented by 4 grid points → 4N \eqn{\simeq} 4(TC + 1)  The quadratic grid is used by ECHAM and ERA15. ERA40 is using a linear Gaussian grid reflected by the TL notation.  The following table shows the calculation of the number of latitudes and the triangular truncation for the different grid types:  Gridtype           & Number of latitudes: nlat   & Triangular truncation: ntr linear           &     NINT((ntr\emph{2 + 1)/2)     &     (nlat}2 - 1) / 2 quadratic        &     NINT((ntr\emph{3 + 1)/2)     &     (nlat}2 - 1) / 3 cubic            &     NINT((ntr\emph{4 + 1)/2)     &     (nlat}2 - 1) / 4
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{dv2uv  Divergence and vorticity to U and V wind
       Calculate U and V wind on a Gaussian grid from spherical harmonic 
       coefficients of relative divergence and vorticity. The divergence and vorticity 
       need to have the names sd and svo or code numbers 155 and 138.
uv2dv  U and V wind to divergence and vorticity
       Calculate spherical harmonic coefficients of relative divergence and vorticity
       from U and V wind. The U and V wind need to be on a Gaussian grid and need to have the 
       names u and v or the code numbers 131 and 132.
}\if{html}{\out{</div>}}
}
\section{Note}{

To speed up the calculations, the Legendre polynoms are kept in memory. This requires a relatively large amount of memory. This is for example 12GB for T1279 data.
}

