% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-yseasarith.R, R/op-cdo-yseasadd.R,
%   R/op-cdo-yseasdiv.R, R/op-cdo-yseasmul.R, R/op-cdo-yseassub.R
\name{yseasarith}
\alias{yseasarith}
\alias{cdo_yseasadd}
\alias{cdo_yseasdiv}
\alias{cdo_yseasmul}
\alias{cdo_yseassub}
\title{Multiyear seasonal arithmetic}
\usage{
cdo_yseasadd(ifile1, ifile2, ofile = NULL)

cdo_yseasdiv(ifile1, ifile2, ofile = NULL)

cdo_yseasmul(ifile1, ifile2, ofile = NULL)

cdo_yseassub(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module performs simple arithmetic of a time series and one timestep with the same season. For each field in infile1 the corresponding field of the timestep in infile2 with the same season is used. The input files need to have the same structure with the same variables. Usually infile2 is generated by an operator of the module YSEASSTAT.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{yseasadd  Add multi-year seasonal time series
          Adds a time series and a multi-year seasonal time series.
yseassub  Subtract multi-year seasonal time series
          Subtracts a time series and a multi-year seasonal time series.
yseasmul  Multiply multi-year seasonal time series
          Multiplies a time series and a multi-year seasonal time series.
yseasdiv  Divide multi-year seasonal time series
          Divides a time series and a multi-year seasonal time series.
}\if{html}{\out{</div>}}
}
