% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt-loop-invariant.R
\name{opt_loop_invariant}
\alias{opt_loop_invariant}
\title{Optimizer: Loop-invariant Code Motion.}
\usage{
opt_loop_invariant(texts)
}
\arguments{
\item{texts}{A list of character vectors with the code to optimize.}
}
\description{
Performs one loop-invariant code motion pass.
Carefully examine the results after running this function!
}
\examples{
code <- paste(
  "i <- 0",
  "while (i < n) {",
  "  x <- y + z",
  "  a[i] <- 6 * i + x * x",
  "  i <- i + 1",
  "}",
  sep = "\n"
)
cat(opt_loop_invariant(list(code))$codes[[1]])
}
