% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareGLM.r
\name{compareGLM}
\alias{compareGLM}
\title{Compare fit statistics for glm models}
\usage{
compareGLM(fits, ...)
}
\arguments{
\item{fits}{A series of model object names, separated by commas.}

\item{...}{Other arguments passed to \code{list}.}
}
\value{
A list of two objects: The series of model calls, and a data 
        frame of statistics for each model.
}
\description{
Produces a table of fit statistics for multiple glm models.
}
\details{
Produces a table of fit statistics for multiple glm models: 
          AIC, AICc, BIC, p-value, pseudo R-squared
          (McFadden, Cox and Snell, Nagelkerke).
          
          Smaller values for AIC, AICc, and BIC indicate a better balance
          of goodness-of-fit of the model and the complexity of the
          model. The goal is to find a model that adequately explains the 
          data without having too many terms.
          
          BIC tends to choose models with fewer parameters relative to AIC.
          For comparisons with AIC, etc., to be valid, both models must
          have the same data, without transformations, use the same 
          dependent variable, and be fit with the same method.
          They do not need to be nested.
          
          The function will fail if a model formula is
          longer than 500 characters.
}
\examples{
### Compare among logistic regresion models
data(AndersonBias)
model.0 = glm(Result ~ 1, weight = Count, data = AndersonBias,
             family = binomial(link="logit"))
model.1 = glm(Result ~ County, weight = Count, data = AndersonBias,
             family = binomial(link="logit"))
model.2 = glm(Result ~ County + Sex, weight = Count, data = AndersonBias,
             family = binomial(link="logit"))
model.3 = glm(Result ~ County + Sex + County:Sex, weight = Count, 
             data = AndersonBias, family = binomial(link="logit"))
compareGLM(model.0, model.1, model.2, model.3)              

}
\references{
\url{http://rcompanion.org/rcompanion/e_07.html}
}
\seealso{
\code{\link{compareLM}}, \code{\link{pairwiseModelAnova}}, \code{\link{accuracy}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{AIC BIC AICc p-value pseudo R-squared glm}
