% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{refresh}
\alias{refresh}
\title{Refresh a package/research compendium}
\usage{
refresh(compendium = NULL, make = FALSE, check = TRUE, quiet = FALSE)
}
\arguments{
\item{compendium}{a character of length 1

The name of the folder to recursively detect dependencies to be added to
the \code{Imports} field of \code{DESCRIPTION} file. It can be \code{'analysis/'} (if
additional folders, i.e. \verb{data/}, \verb{outputs/}, \verb{figures/}, etc. have been
created in this folder), \code{'.'} (if folders \verb{data/}, \verb{outputs/},
\verb{figures/}, etc. have been created at the root of the project), etc.
See \code{\link[=new_compendium]{new_compendium()}} for further information.

Default is \code{compendium = NULL} (i.e. no additional folder are inspected
but \verb{R/}, \code{NAMESPACE}, \verb{vignettes/}, and \verb{tests/} are still inspected).}

\item{make}{a logical value

If \code{TRUE} the Make-like R file \code{make.R} is sourced. Only for research
compendium created with \code{\link[=new_compendium]{new_compendium()}}. Default is \code{FALSE}.}

\item{check}{a logical value

If \code{TRUE} (default) package integrity is checked using \code{\link[devtools:check]{devtools::check()}}.}

\item{quiet}{a logical value

If \code{TRUE} (default) message are deleted.}
}
\value{
None
}
\description{
This function refreshes a package/research compendium. It will:
\itemize{
\item Update \code{.Rd} files and \code{NAMESPACE} by using \code{\link[devtools:document]{devtools::document()}};
\item Update external packages (in \code{DESCRIPTION} file) by using
\code{\link[=add_dependencies]{add_dependencies()}};
\item Update badges in \code{README.Rmd} (if already present);
\item Re-knitr the \code{README.Rmd} by using \code{\link[rmarkdown:render]{rmarkdown::render()}};
\item Check package integrity by using \code{\link[devtools:check]{devtools::check()}};
\item Run analysis by sourcing \code{make.R} (only for compendium).
}
}
\examples{
\dontrun{
library(rcompendium)

## Create an R package ----
new_package()

## Start developing functions ----
## ...

## Update package (documentation, dependencies, README, check) ----
refresh()
}
}
\seealso{
Other setup functions: 
\code{\link{new_compendium}()},
\code{\link{new_package}()},
\code{\link{set_credentials}()}
}
\concept{setup functions}
