% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDat.R
\name{window.CMBDat}
\alias{window.CMBDat}
\title{Get a sub window from a \code{\link{CMBDat}} object}
\usage{
\method{window}{CMBDat}(x, new.window, intersect = TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{CMBDat}} object.}

\item{new.window}{A single \code{\link{CMBWindow}} object or a list of them.}

\item{intersect}{A boolean that determines
the behaviour when \code{new.window} is a list containing BOTH
regular type and "minus" type windows together (see details).}

\item{...}{Unused arguments.}
}
\value{
A CMBDataFrame containing the data in \code{x} restricted to the
CMBWindow \code{new.window}
}
\description{
This function returns a
data.frame containing the data in \code{x} restricted to the
CMBWindow \code{new.window}
}
\details{
Windows that are tagged with \code{set.minus} (see \code{\link{CMBWindow}})
are treated differently from other windows.

If the argument is a list of CMBWindows, then interious of all windows whose
winType does not include "minus" are united (let \eqn{A} be their union) and
exteriors of all windows whose winType does include "minus" are intersected,
(let \eqn{B} be their intersection). Then, provided that
\code{intersect = TRUE} (the default), the returned data.frame will
be the points of \code{cmbdat$data} in the the intersection of
\eqn{A} and \eqn{B}.
Otherwise, if \code{intersect = FALSE}, the returned data.frame
consists of the points of \code{x$data} in the union of
\eqn{A} and \eqn{B}.

Note that if \eqn{A} (resp. \eqn{B}) is empty then the returned data.frame
will be the points of \code{x} in \eqn{B} (resp. \eqn{A}).
}
\examples{

win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))

## Ensure you have a FITS file with correct path
## before uncommenting and running the rest of the example:
# cmbdat <- CMBDat("CMB_map_smica1024.fits", mmap = TRUE)
# class(cmbdat)
# cmbdat.win <- window(cmbdat, new.window = win1)
# class(cmbdat.win)

}
