% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_sens_cutoff.R
\name{rd_sens_cutoff}
\alias{rd_sens_cutoff}
\title{Cutoff Sensitivity Simulation for Regression Discontinuity}
\usage{
rd_sens_cutoff(object, cutoffs)
}
\arguments{
\item{object}{An object returned by \code{rd_est} or \code{rd_impute}.}

\item{cutoffs}{A numeric vector of cutoff values to be used in the refitting 
of an \code{rd} object.}
}
\value{
A dataframe contains the estimate \code{est} and standard error \code{se} 
  for each cutoff values (\code{A1}). Column \code{A1} contains varying cutoffs 
  on the assignment variable.
}
\description{
\code{rd_sens_cutoff} refits the supplemented model with varying cutoff(s). 
Other estimation parameters, such as the automatically calculated bandwidth, are held constant.
}
\examples{
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
rd <- rd_est(y ~ x | cov)
rd_sens_cutoff(rd, seq(-.5, .5, length.out = 10))
}
