% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mfrd.R
\name{summary.mfrd}
\alias{summary.mfrd}
\title{Summarize the Multivariate Frontier Regression Discontinuity}
\usage{
\method{summary}{mfrd}(object, level = 0.95, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"mfrd"}, usually a result of a call to \code{\link{mfrd_est}}.}

\item{level}{A numeric value between 0 and 1 specifying the confidence level for confidence intervals. The default is 0.95.}

\item{digits}{A non-negative integer specifying the number of digits to display.
The default is \code{max(3, getOption("digits") - 3)}.}

\item{...}{Additional arguments passed to \code{summary}.}
}
\value{
\code{summary.mfrd} returns a list containing the following components:
\item{coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the complete model.}
\item{ht_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the heterogeneous treatment model.}
\item{t_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the treatment only model.}
}
\description{
\code{summary.mfrd} is a \code{summary} method for class \code{"mfrd"}.
It is based on the \code{summary.RD} function in the "rdd" package.
}
\references{
Drew Dimmery (2016). rdd: Regression Discontinuity Estimation. R package
   version 0.57. https://CRAN.R-project.org/package=rdd
}
