% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-process-tracing.R
\name{process_tracing_estimator}
\alias{process_tracing_estimator}
\title{Process tracing estimator}
\usage{
process_tracing_estimator(causal_model, query, data, strategies)
}
\arguments{
\item{causal_model}{a model generated by \code{CausalQueries}}

\item{query}{a causal query of interest}

\item{data}{a single row dataset with data on nodes in the model}

\item{strategies}{a vector describing sets of nodes to be examined e.g. c("X", "X-Y")}
}
\value{
a data.frame of estimates
}
\description{
Draw conclusions from a model given a query, data, and process tracing strategies
}
\details{
See https://book.declaredesign.org/observational-causal.html#process-tracing
}
\examples{
# Simple example showing ambiguity in attribution
process_tracing_estimator(
  causal_model = CausalQueries::make_model("X -> Y"),
  query = "Y[X=1] > Y[X=0]",
  data = data.frame(X=1, Y = 1),
  strategies = "X-Y")

# Example where M=1 acts as a hoop test
process_tracing_estimator(
  causal_model = CausalQueries::make_model("X -> M -> Y") |>
   CausalQueries::set_restrictions("Y[M=1] < Y[M=0]") |>
   CausalQueries::set_restrictions("M[X=1] < M[X=0]"),
  query = "Y[X=1] > Y[X=0]",
  data = data.frame(X=1, Y = 1, M = 0),
  strategies = c("Y", "X-Y", "X-M-Y"))
}
