% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkIndex.R
\name{checkIndex}
\alias{checkIndex}
\title{check indexes}
\usage{
checkIndex(
  findex = NULL,
  mindex = NULL,
  gindex = NULL,
  excludefp = TRUE,
  fast = FALSE,
  warn = !quiet,
  logfile = localtestdir(".", "misc/ExampleTests/warnings.txt"),
  quiet = rdwdquiet()
)
}
\arguments{
\item{findex}{\code{\link{fileIndex}}. DEFAULT: NULL}

\item{mindex}{\code{\link{metaIndex}}. DEFAULT: NULL}

\item{gindex}{\code{\link{geoIndex}}.  DEFAULT: NULL}

\item{excludefp}{Exclude false positives from geoIndex coordinate check results?
DEFAULT: TRUE}

\item{fast}{Exclude the 3-minute location per ID check? DEFAULT: FALSE}

\item{warn}{Warn about issues? DEFAULT: \code{!quiet} (TRUE)}

\item{logfile}{File to copy log to, appended to existing content. NULL to suppress.
DEFAULT: "misc/ExampleTests/warnings.txt"}

\item{quiet}{Logical: Suppress progress messages?
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
Charstring with issues (if any) to be printed with \code{\link[=cat]{cat()}}.
}
\description{
check indexes. Mainly for internal usage in \code{\link[=createIndex]{createIndex()}}.
Not exported, so call it as rdwd:::checkIndex() if you want to
run tests yourself. Further test suggestions are welcome!
}
\examples{
data(fileIndex) ; data(metaIndex) ; data(geoIndex)
# ci <- rdwd:::checkIndex(findex=fileIndex, mindex=metaIndex, gindex=geoIndex)
# cat(ci)
}
\seealso{
\code{\link{createIndex}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2019
}
