% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_lines_chunked.R
\name{read_lines_chunked}
\alias{read_lines_chunked}
\alias{read_lines_raw_chunked}
\title{Read lines from a file or string by chunk.}
\usage{
read_lines_chunked(
  file,
  callback,
  chunk_size = 10000,
  skip = 0,
  locale = default_locale(),
  na = character(),
  progress = show_progress()
)

read_lines_raw_chunked(
  file,
  callback,
  chunk_size = 10000,
  skip = 0,
  progress = show_progress()
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{callback}{A callback function to call on each chunk}

\item{chunk_size}{The number of rows to include in each chunk}

\item{skip}{Number of lines to skip before reading data.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}
}
\description{
Read lines from a file or string by chunk.
}
\seealso{
Other chunked: 
\code{\link{callback}},
\code{\link{melt_delim_chunked}()},
\code{\link{read_delim_chunked}()}
}
\concept{chunked}
\keyword{internal}
