% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle.R
\name{step_shuffle}
\alias{step_shuffle}
\title{Shuffle Variables}
\usage{
step_shuffle(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("shuffle")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string that contains the names of
columns that should be shuffled. These values are not determined
until \code{\link[=prep.recipe]{prep.recipe()}} is called.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_shuffle} creates a \emph{specification} of a recipe
step that will randomly change the order of rows for selected
variables.
}
\details{
When you \code{\link[=tidy]{tidy()}} this step, a tibble with column \code{terms} (the
columns that will be permuted) is returned.
}
\examples{
integers <- data.frame(A = 1:12, B = 13:24, C = 25:36)

library(dplyr)
rec <- recipe(~ A + B + C, data = integers) \%>\%
  step_shuffle(A, B)

rand_set <- prep(rec, training = integers)

set.seed(5377)
bake(rand_set, integers)

tidy(rec, number = 1)
tidy(rand_set, number = 1)
}
\seealso{
Other row operation steps: 
\code{\link{step_arrange}()},
\code{\link{step_filter}()},
\code{\link{step_impute_roll}()},
\code{\link{step_lag}()},
\code{\link{step_naomit}()},
\code{\link{step_sample}()},
\code{\link{step_slice}()}
}
\concept{row operation steps}
