% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{step_time}
\alias{step_time}
\title{Time Feature Generator}
\usage{
step_time(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  features = c("hour", "minute", "second"),
  columns = NULL,
  keep_original_cols = TRUE,
  skip = FALSE,
  id = rand_id("time")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. The selected variables should have class
\code{POSIXct} or \code{POSIXlt}. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{features}{A character string that includes at least one
of the following values: \code{am} (is is AM), \code{hour}, \code{hour12}, \code{minute},
\code{second}, \code{decimal_day}.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{TRUE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_time()} creates a \emph{specification} of a recipe step that will convert
date-time data into one or more factor or numeric variables.
}
\details{
Unlike some other steps, \code{step_time()} does \emph{not}
remove the original time variables by default. Set \code{keep_original_cols}
to \code{FALSE} to remove them.

\code{decimal_day} return time of day as a decimal number between 0 and 24. for
example \code{"07:15:00"} would be transformed to \code{7.25}  and \code{"03:59:59"} would
be transformed to \code{3.999722}. The formula for these calculations are
\code{hour(x) + (second(x) + minute(x) * 60) / 3600}.

See \code{\link[=step_date]{step_date()}} if you want to calculate features that are larger than
hours.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the selectors or variables selected) and \code{value} (the feature
names).
}

\examples{
library(lubridate)

examples <- data.frame(
  times = ymd_hms("2022-05-06 23:51:07") +
  hours(1:5) + minutes(1:5) + seconds(1:5)
)
time_rec <- recipe(~ times, examples) \%>\%
  step_time(all_predictors())

tidy(time_rec, number = 1)

time_rec <- prep(time_rec, training = examples)

time_values <- bake(time_rec, new_data = examples)
time_values

tidy(time_rec, number = 1)
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
