% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExecMetadata.R
\docType{methods}
\name{updateExecMeta}
\alias{updateExecMeta}
\alias{updateExecMeta,Recordr-method}
\title{Update a single execution metadata object.}
\usage{
updateExecMeta(recordr, ...)

\S4method{updateExecMeta}{Recordr}(recordr, executionId = as.character(NA),
  subject = as.character(NA), endTime = as.character(NA),
  errorMessage = as.character(NA), publishTime = as.character(NA),
  publishNodeId = as.character(NA), publishId = as.character(NA))
}
\arguments{
\item{recordr}{A Recordr object}

\item{...}{additional arguments}

\item{executionId}{The execution id of the execution to be updated}

\item{subject}{The authorized subject, i.e. from the client certificate.}

\item{endTime}{The ending time of the exection.}

\item{errorMessage}{An error message generated by the execution.}

\item{publishTime}{The data and time that the execution was published}

\item{publishNodeId}{The node identifier, e.g. "urn:node:testKNB" that the execution was published to.}

\item{publishId}{The identifier that the execution was published with. In DataONE, this can be
the identifier of the metadata object describing the datasets that were uploaded.}
}
\description{
UPdate an existing execution metadata entry with the
values supplied.
}
\details{
Saved execution metadata is typically first stored when
an execution begins, then updated at the end of a run (with error messages
and ending time, for example). Also, excution can be updated when a run
is published, with information about the publishing process.
}
\seealso{
\code{\link[=ExecMetadata-class]{ExecMetadata}} { class description}
}

