% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumerate.R
\name{redist.samplepart}
\alias{redist.samplepart}
\title{Sample partitions using spanning trees}
\usage{
redist.samplepart(adjobj, ndists, popvec, pop_filter, pop_constraint,
contiguitymap, nsamp, n_cores)
}
\arguments{
\item{adjobj}{An adjacency list, matrix, or object of class
\code{SpatialPolygonsDataFrame}.}

\item{ndists}{The desired number of congressional districts}

\item{popvec}{Population vector for adjacency object. Provide if
filtering by population}

\item{pop_filter}{Boolean. Whether or not to filter on population parity.
Default is FALSE.}

\item{pop_constraint}{Strength of population filter if filtering on
distance to parity.}

\item{contiguitymap}{Use queens or rooks distance criteria for generating an
adjacency list from a "SpatialPolygonsDataFrame" data type.
Default is "rooks".}

\item{nsamp}{Number of samples to draw. Default is 1000.}

\item{n_cores}{Number of cores to parallelize over for parity calculation and
compactness calculation. Default is 1.}
}
\value{
\code{redist.samplepart} returns a list where the first entry is the
randomly sampled redistricting plan, and the second entry is the number of
possible redistricting plans from the implied spanning tree.
}
\description{
\code{redist.samplepart} uses a spanning tree method to randomly sample
redistricting plans.
}
