% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interactive.R
\name{redist.plot.interactive}
\alias{redist.plot.interactive}
\title{Display an interactive map}
\usage{
redist.plot.interactive(
  map,
  fill = NULL,
  scale = ggplot2::scale_fill_viridis_c,
  limits = NULL,
  useGL = FALSE
)
}
\arguments{
\item{map}{the \code{\link{redist_map}} object}

\item{fill}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} If
present, will be used to color the map units.}

\item{scale}{the color scale to use, for numeric \code{fill}.}

\item{limits}{the color scale limits. Defaults to the range of the data.}

\item{useGL}{if \code{TRUE} and \code{leafgl} is installed, use WebGL for
faster plotting.}
}
\value{
a Leaflet object
}
\description{
Plots an interactive Leaflet map of a \code{\link{redist_map}} object,
optionally colored by a quantity of interest. May also be accessed by setting
\code{interactive=TRUE} in \code{\link{plot.redist_map}}.
}
\details{
If \code{leafgl} is installed, will use its faster rendering functions to
plot the map, which may be useful for larger maps.
}
