% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_deprecations.R, R/deprecations.R
\name{muni_splits}
\alias{muni_splits}
\alias{redist.muni.splits}
\title{Counts the Number of Municipalities Split Between Districts}
\usage{
muni_splits(map, munis, .data = cur_plans())

redist.muni.splits(plans, munis)
}
\arguments{
\item{map}{a \code{\link{redist_map}} object}

\item{munis}{A vector of municipality names or ids.}

\item{.data}{a \code{\link{redist_plans}} object}

\item{plans}{A numeric vector (if only one map) or matrix with one row
for each precinct and one column for each map. Required.}
}
\value{
integer vector of length ndist by ncol(plans)
}
\description{
Counts the total number of municpalities that are split.
Municipalities in this interpretation do not need to cover the entire state, which
differs from counties.
}
\examples{
data(iowa)
ia <- redist_map(iowa, existing_plan = cd_2010, total_pop = pop, pop_tol = 0.01)
plans <- redist_smc(ia, 50, silent = TRUE)
ia$region[1:10] <- NA
#old redist.muni.splits(plans, ia$region)
splits_sub_admin(plans, ia, region)
}
\concept{analyze}
