% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.table.R
\name{cor.table}
\alias{cor.table}
\title{make the correlation matrix from the data.frame used in regression}
\usage{
cor.table(
  data,
  data_to_combine = NULL,
  var_name_select = NULL,
  all.var.names = NULL,
  d = 2
)
}
\arguments{
\item{data}{a data.frame used in regression model, e.g. model$model}

\item{data_to_combine}{another data.frame used for regression model, e.g. when you have similar set of X's but different Y's}

\item{var_name_select}{optional: to specify the variable names used in regression to be included in the correlation matrix}

\item{all.var.names}{optional: to rename all variable names, a string vector}

\item{d}{number of decimal places to retain}
}
\description{
make the correlation matrix from the data.frame used in regression
}
\examples{
data(mtcars)
model <- lm(mpg ~ vs + carb + hp + wt + wt * hp , data = mtcars)
cor.table(data = model$model)

}
