% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{degreeDiff}
\alias{degreeDiff}
\title{degreeDiff}
\usage{
degreeDiff(scaling = c("none", "std"), consider_type = TRUE)
}
\arguments{
\item{scaling}{the method for scaling the degree statistic. Default is to
not scale the statistic (scaling = "none"). Alternatively, standardization
of the degree difference per time point can be requested with `std`.}

\item{consider_type}{logical, indicates whether to count the degrees
separately for each event type (TRUE, default) or sum degrees across
different event types (FALSE).}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a `degreeDiff` effect in the tie-oriented
model.
}
\details{
A degreeDiff effect refers to the tendency for dyads to increase their
interaction rate if the absolute difference in degree for the two actors in
the pair increases. The statistic at timepoint \emph{t} for dyad
\emph{(i,j)} is equal to the difference between the following two values:
the number of events before timepoint \emph{t} that involved actor \emph{i}
and actor \emph{j}, respectively. The degreeDiff effect is only defined for
undirected events.
}
\examples{
reh_tie <- remify::remify(history, model = "tie", directed = FALSE)
effects <- ~ degreeDiff()
remstats(reh = reh_tie, tie_effects = effects)

}
\seealso{
\code{\link{degreeMin}}, \code{\link{degreeMax}} or
\code{\link{totaldegreeDyad}} for other types of degree effects for
undirected events.
}
