% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{same}
\alias{same}
\title{same}
\usage{
same(variable, attr_actors = NULL, attr_data)
}
\arguments{
\item{variable}{string with the name of the column in the
\code{attr_actors} object for which the statistic has to be computed.}

\item{attr_actors}{optionally, an object of class
\code{\link[base]{data.frame}} that contains the attribute, see
'Details.'}

\item{attr_data}{Deprecated argument. Please use 'attr_actors' instead.}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a "same" effect in the tie-oriented model or the
receiver choice step of the actor-oriented model. A "same" effect refers to
an exogenous actor attribute that affects dyad \emph{(i,j)}'s rate of
interacting (tie-oriented model) or actor \emph{j}'s probability of being
chosen as a receiver for the event send by the active sender \emph{i} at
time \emph{t} (actor-oriented model) based on whether actors \emph{i} and
\emph{j} have the same value (or not) on this attribute.
}
\details{
The statistic at timepoint \emph{t} is equal to one for dyads \emph{(i,j)}
that have the same value on the attribute at timepoint \emph{t}
(tie-oriented model) or one for receivers \emph{j} that have the same value
on the attribute as the active sender \emph{i} at timepoint \emph{t}
(actor-oriented model) and equal to 0 for dyads and receivers that do not
have the same value.

Construct the `attr_actors` object as a data frame where each row represents 
the attribute value of actor \emph{i} at timepoint \emph{t}:
\itemize{
  \item{name:} The actors' name.
  \item{time:} The time when the attribute values change.
  \item{variable:} The third column contains the attribute used in the
  specification of the "difference" effect. The column name should correspond
  to the string supplied to the \code{variable} argument in the `difference()`
  function.
}

Note that it is possible to omit the `attr_actors` object in the call of
\code{difference()} and, instead, supply it in the call of \code{remstats()}
for multiple exogenous effects.
}
\examples{
reh_tie <- remify::remify(history, model = "tie")
effects <- ~ same("age")
remstats(reh = reh_tie, tie_effects = effects, attr_actors = info)

reh_actor <- remify::remify(history, model = "actor")
remstats(reh = reh_actor, receiver_effects = effects, attr_actors = info)

}
