% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{boxplot.tomstats}
\alias{boxplot.tomstats}
\title{Plotting Relational Event Network Statistics Distributions}
\usage{
\method{boxplot}{tomstats}(x, effect, by = "timepoints", subset = NULL, outliers = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{tomstats}} containing relational
event network statistics.}

\item{effect}{A character string specifying the name of the effect in 'x' or
an integer indicating the index of the effect to be plotted.}

\item{by}{A string indicating whether the statistic is plotted across
'timepoints' (default) or 'dyads'.}

\item{subset}{An optional vector specifying a subset of timepoints or dyads
to be used for plotting. Per default, a maximum of 20 unique timepoints or 
dyads are plotted.}

\item{outliers}{A logical value specifying whether to include outliers in the
plot.}

\item{...}{Additional arguments passed to bxp().}
}
\value{
no return value
}
\description{
Generate boxplots for a specified effect in a \code{\link{tomstats}}
object.
}
\details{
This function produces boxplots to visually represent the distribution of a
specified effect in a relational event network, as captured by a
\code{\link{tomstats}} object. The 'effect' parameter allows the user to
choose a specific effect for visualization, either by providing the effect's
name or its index within the 'tomstats' object. The 'by' parameter determines
whether the boxplots are created across different 'timepoints' or 'dyads'.
Additionally, an optional 'subset' parameter allows the user to focus on
specific timepoints or dyads. If 'subset' is not specified, a default
maximum of 20 unique timepoints or dyads are plotted. The 'outliers'
argument, when set to TRUE, includes the representation of outliers in the
boxplots. If set to FALSE, outliers are omitted from the visualization.

The boxplots are based on the following summary statistics of the data: The
box in the middle represents the interquartile range (IQR) between the first
(Q1) and third quartile (Q3), and the line inside the box represents the
median. The whiskers extend from the box to the minimum and maximum values
within 1.5 times the IQR below Q1 or above Q3. Outliers beyond the whiskers
are plotted individually.
}
\examples{
library(remstats)
# Load data
data(history)
# Prepare data
reh <- remify::remify(edgelist = history[,1:3], model = "tie")
# Compute effects
stats <- remstats(reh, tie_effects = ~ inertia())
# Plot the 'inertia' distribution for 20 timepoints
boxplot(stats, effect = "inertia")
# Plot the 'inertia' distribution for 20 dyads
boxplot(stats, effect = "inertia", by = "dyads")
# Plot the 'inertia' distribution for dyads 2:5
boxplot(stats, effect = "inertia", by = "dyads", subset = 2:5)

}
