% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/entrez_link.r
\name{entrez_link}
\alias{entrez_link}
\title{Get links to datasets related to a unique ID from an NCBI database}
\usage{
entrez_link(db, dbfrom, config = NULL, ...)
}
\arguments{
\item{db}{character Name of the database to search for links (or use "all" to
search all databases available for \code{db}. \code{entrez_db_links} allows you
to discover databases that might have linked information (see examples).}

\item{dbfrom}{character Name of database from which the Id(s) originate}

\item{config}{vector configuration options passed to httr::GET}

\item{\dots}{character Additional terms to add to the request}
}
\value{
An elink object containing vectors of unique IDs
the vectors names take the form [db_from]_[db_to]

file XMLInternalDocument xml file resulting from search, parsed with
\code{\link{xmlTreeParse}}
}
\description{
Constructs a query with the given arguments and downlands the XML
document created by that query.
}
\examples{
\donttest{
 (pubmed_search <- entrez_search(db = "pubmed", term ="10.1016/j.ympev.2010.07.013[doi]"))
 (linked_dbs <- entrez_db_links("pubmed"))
 nucleotide_data <- entrez_link(dbfrom = "pubmed", id = pubmed_search$ids, db ="nuccore")
 #All the links
 entrez_link(dbfrom="pubmed", db="all", id=pubmed_search$ids)
}
}
\seealso{
\code{\link[httr]{config}} for available configs
}

