% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/entrez_info.r
\name{entrez_db_links}
\alias{entrez_db_links}
\title{Can be used in conjunction with \code{\link{entrez_link}} to find
the right name for the \code{db} argument in that function.}
\usage{
entrez_db_links(db, config = NULL)
}
\arguments{
\item{db}{character, name of database t}

\item{config}{config vector passed to \code{httr::GET}}
}
\value{
An eInfoLink object (sub-classed from list) summarising linked-databases.
Can be coerced to a data-frame with \code{as.data.frame}. Printing the object
the name of each element (which is the correct name for \code{entrez_link},
and can be used to get (a little) more information about each linked database
(see example below).
}
\description{
Can be used in conjunction with \code{\link{entrez_link}} to find
the right name for the \code{db} argument in that function.
}
\examples{
\donttest{
taxid <- entrez_search(db="taxonomy", term="Osmeriformes")$ids
(tax_links <- entrez_db_links("taxonomy"))
tax_links[["pubmed"]]
entrez_link(dbfrom="taxonomy", db="pmc", id=taxid)

sra_links <- entrez_db_links("sra")
as.data.frame(sra_links)
}
}
\seealso{
\code{\link{entrez_link}}

Other einfo: \code{\link{entrez_db_searchable}};
  \code{\link{entrez_db_summary}};
  \code{\link{entrez_dbs}}; \code{\link{entrez_info}}
}

