% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.lavaan.R
\name{report.lavaan}
\alias{report.lavaan}
\alias{report_performance.lavaan}
\title{Reports of Structural Equation Models (SEM)}
\usage{
\method{report}{lavaan}(x, ...)

\method{report_performance}{lavaan}(x, table = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{lavaan}.}

\item{...}{Arguments passed to or from other methods.}

\item{table}{Provide the output of  \code{report_table()} to avoid its
re-computation.}
}
\value{
An object of class \code{\link{report}}.
}
\description{
Create a report for \code{lavaan} objects.
}
\examples{
library(report)

\donttest{
# Structural Equation Models (SEM)
if (require("lavaan")) {
  structure <- " ind60 =~ x1 + x2 + x3
                 dem60 =~ y1 + y2 + y3
                 dem60 ~ ind60 "
  model <- lavaan::sem(structure, data = PoliticalDemocracy)
  r <- report(model)
  r
  # summary(r)
  # as.data.frame(r)
  # summary(as.data.frame(r))

  # Specific reports
  report_table(model)
  report_performance(model)
}
}
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
  \item \code{\link{report_table}}
  \item \code{\link{report_parameters}}
  \item \code{\link{report_statistics}}
  \item \code{\link{report_effectsize}}
  \item \code{\link{report_model}}
  \item \code{\link{report_priors}}
  \item \code{\link{report_random}}
  \item \code{\link{report_performance}}
  \item \code{\link{report_info}}
  \item \code{\link{report_text}}
}
Other types of reports:
\itemize{
  \item \code{\link{report_system}}
  \item \code{\link{report_packages}}
  \item \code{\link{report_participants}}
  \item \code{\link{report_sample}}
  \item \code{\link{report_date}}
}
Methods:
\itemize{
  \item \code{\link{as.report}}
}
Template file for supporting new models:
\itemize{
  \item \code{\link{report.default}}
}
}
